/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.rec.fast.basic;

import es.uam.eps.ir.ranksys.fast.FastRecommendation;
import es.uam.eps.ir.ranksys.fast.preference.FastPreferenceData;
import es.uam.eps.ir.ranksys.rec.fast.AbstractFastRecommender;
import java.util.Comparator;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import org.ranksys.core.util.tuples.Tuple2id;
import org.ranksys.core.util.tuples.Tuples;

public class PopularityRecommender<U, I>
extends AbstractFastRecommender<U, I> {
    private final List<Tuple2id> popList;

    public PopularityRecommender(FastPreferenceData<U, I> data) {
        super(data, data);
        this.popList = data.getIidxWithPreferences().mapToObj(iidx -> Tuples.tuple((int)iidx, (double)data.numUsers(iidx))).sorted(Comparator.comparingDouble(Tuple2id::v2).reversed()).collect(Collectors.toList());
    }

    @Override
    public FastRecommendation getRecommendation(int uidx, int maxLength, IntPredicate filter) {
        List items = this.popList.stream().filter(is -> filter.test(is.v1)).limit(Math.min(maxLength, this.popList.size())).collect(Collectors.toList());
        return new FastRecommendation(uidx, items);
    }
}

