/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.rec.runner;

import es.uam.eps.ir.ranksys.core.feature.FeatureData;
import es.uam.eps.ir.ranksys.core.preference.PreferenceData;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.ranksys.core.util.tuples.Tuple2od;

public class Filters {
    public static <U, I> Function<U, Predicate<I>> all() {
        return user -> item -> true;
    }

    public static <U, I> Function<U, Predicate<I>> notInTrain(PreferenceData<U, I> trainData) {
        return user -> {
            Set set = trainData.getUserPreferences(user).map(Tuple2od::v1).collect(Collectors.toSet());
            return i -> !set.contains(i);
        };
    }

    public static <U, I, F> Function<U, Predicate<I>> withFeatures(FeatureData<I, F, ?> featureData) {
        Set itemsWithFeatures = featureData.getItemsWithFeatures().collect(Collectors.toSet());
        return user -> item -> itemsWithFeatures.contains(item);
    }

    public static <U> Function<U, Predicate<U>> notSelf() {
        return user1 -> user2 -> !user1.equals(user2);
    }

    public static <U, I> Function<U, Predicate<I>> and(Function<U, Predicate<I>> ... filters) {
        return user -> {
            Predicate<Object> andPredicate = item -> true;
            for (Function filter : filters) {
                andPredicate = andPredicate.and((Predicate)filter.apply(user));
            }
            return andPredicate;
        };
    }
}

