/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.rapidoid.aop.AOPInterceptor;
import org.rapidoid.aop.ForwardCall;
import org.rapidoid.aop.InterceptorConfig;
import org.rapidoid.arr.Arr;
import org.rapidoid.lambda.Lambdas;

public class AOP {
    private static volatile InterceptorConfig[] INTERCEPTORS = new InterceptorConfig[0];

    public static void reset() {
        INTERCEPTORS = new InterceptorConfig[0];
    }

    public static synchronized void intercept(AOPInterceptor interceptor, Class<? extends Annotation> ... annotated) {
        InterceptorConfig config = new InterceptorConfig(interceptor, annotated);
        INTERCEPTORS = (InterceptorConfig[])Arr.expand((Object[])INTERCEPTORS, (Object)config);
    }

    public static <T> T invoke(Object context, Method m, Object target, Object ... args) {
        Annotation[] annotations = m.getAnnotations();
        ForwardCall call = new ForwardCall(context, annotations, m, target, args, INTERCEPTORS, 0);
        return (T)Lambdas.call((Callable)call);
    }
}

