/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.rapidoid.aop.InterceptorConfig;
import org.rapidoid.beany.Metadata;
import org.rapidoid.cls.Cls;
import org.rapidoid.log.Log;

public class ForwardCall
implements Callable<Object> {
    private final Object context;
    private final Annotation[] annotations;
    private final Method m;
    private final Object target;
    private final Object[] args;
    private final InterceptorConfig[] interceptors;
    private final int index;

    public ForwardCall(Object context, Annotation[] annotations, Method m, Object target, Object[] args, InterceptorConfig[] interceptors, int index) {
        this.context = context;
        this.annotations = annotations;
        this.m = m;
        this.target = target;
        this.args = args;
        this.interceptors = interceptors;
        this.index = index;
    }

    @Override
    public Object call() throws Exception {
        for (int i = this.index; i < this.interceptors.length; ++i) {
            InterceptorConfig ic = this.interceptors[i];
            Annotation ann = null;
            boolean any = ic.annotated.isEmpty();
            if (!any) {
                ann = ForwardCall.findAnnotation(this.annotations, ic);
            }
            if (!any && ann == null) continue;
            ForwardCall forward = new ForwardCall(ic, this.annotations, this.m, this.target, this.args, this.interceptors, i + 1);
            Log.debug((String)"Intercepting AOP call", (String)"method", (Object)this.m, (String)"annotation", (Object)ann);
            return ic.interceptor.intercept(forward, ann, this.context, this.m, this.target, this.args);
        }
        return Cls.invoke((Method)this.m, (Object)this.target, (Object[])this.args);
    }

    private static Annotation findAnnotation(Annotation[] annotations, InterceptorConfig ic) {
        for (Class<? extends Annotation> annotated : ic.annotated) {
            Annotation ann = Metadata.get((Annotation[])annotations, annotated);
            if (ann == null) continue;
            return ann;
        }
        return null;
    }
}

