/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.app;

import java.util.Collection;
import java.util.Map;
import org.rapidoid.util.U;

public class AppClasses {
    public final Class<?> main;
    public final Map<String, Class<?>> services;
    public final Map<String, Class<?>> pages;
    public final Map<String, Class<?>> screens;

    public AppClasses(Class<?> main, Map<String, Class<?>> services, Map<String, Class<?>> pages, Map<String, Class<?>> screens) {
        this.main = main;
        this.services = services;
        this.pages = pages;
        this.screens = screens;
    }

    public static AppClasses from(Class<?> ... classes) {
        Class<?> main = null;
        Map services = U.map();
        Map pages = U.map();
        Map screens = U.map();
        for (Class<?> cls : classes) {
            String name = cls.getSimpleName();
            if (name.equals("App")) {
                main = cls;
                continue;
            }
            if (name.endsWith("Service")) {
                services.put(name, cls);
                continue;
            }
            if (name.endsWith("Screen")) {
                screens.put(name, cls);
                continue;
            }
            if (!name.endsWith("Page")) continue;
            pages.put(name, cls);
        }
        return new AppClasses(main, services, pages, screens);
    }

    public static AppClasses from(Collection<Class<?>> classes) {
        Class[] classesArr = new Class[classes.size()];
        classes.toArray(classesArr);
        return AppClasses.from(classesArr);
    }

    public String toString() {
        return "AppClasses [main=" + this.main + ", services=" + this.services + ", pages=" + this.pages + ", screens=" + this.screens + "]";
    }
}

