/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.app;

import org.rapidoid.app.AppClasses;
import org.rapidoid.app.AppPageGeneric;
import org.rapidoid.app.Apps;
import org.rapidoid.db.DB;
import org.rapidoid.http.Handler;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.http.HttpProtocol;
import org.rapidoid.lambda.Callback;
import org.rapidoid.pages.Pages;
import org.rapidoid.rest.WebPojoDispatcher;
import org.rapidoid.util.CustomizableClassLoader;

public class AppHandler
implements Handler {
    private CustomizableClassLoader classLoader;

    public AppHandler() {
        this(null);
    }

    public AppHandler(CustomizableClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Object handle(final HttpExchange x) throws Exception {
        final AppClasses appCls = Apps.scanAppClasses(x, (ClassLoader)this.classLoader);
        Callback<Void> callback = new Callback<Void>(){

            public void onDone(Void result, Throwable error) {
                if (error != null) {
                    x.errorResponse(error);
                }
                x.done();
            }
        };
        x.async();
        DB.transaction((Runnable)new Runnable(){

            @Override
            public void run() {
                Object result = AppHandler.this.processReq(x, appCls);
                HttpProtocol.processResponse((HttpExchange)x, (Object)result);
            }
        }, (boolean)x.isGetReq(), (Callback)callback);
        return x;
    }

    private Object processReq(HttpExchange x, AppClasses appCls) {
        WebPojoDispatcher dispatcher = new WebPojoDispatcher(appCls.services);
        Object result = Pages.dispatch((HttpExchange)x, (WebPojoDispatcher)dispatcher, appCls.pages);
        if (result != null) {
            return result;
        }
        AppPageGeneric view = new AppPageGeneric(x, appCls);
        if (Pages.isEmiting((HttpExchange)x)) {
            return Pages.emit((HttpExchange)x, (Object)((Object)view));
        }
        return Pages.serve((HttpExchange)x, (Object)((Object)view));
    }
}

