/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.app;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rapidoid.annotation.Scaffold;
import org.rapidoid.app.AppClasses;
import org.rapidoid.app.AppGUI;
import org.rapidoid.app.AppScreens;
import org.rapidoid.app.Apps;
import org.rapidoid.app.EditEntityScreenGeneric;
import org.rapidoid.app.ListEntityScreenGeneric;
import org.rapidoid.app.ViewEntityScreenGeneric;
import org.rapidoid.beany.Beany;
import org.rapidoid.beany.Metadata;
import org.rapidoid.config.Conf;
import org.rapidoid.db.DB;
import org.rapidoid.html.Cmd;
import org.rapidoid.html.Tag;
import org.rapidoid.html.tag.ATag;
import org.rapidoid.html.tag.FormTag;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.http.HttpExchangeException;
import org.rapidoid.http.HttpExchangeHolder;
import org.rapidoid.oauth.OAuth;
import org.rapidoid.oauth.OAuthProvider;
import org.rapidoid.pages.Pages;
import org.rapidoid.security.Secure;
import org.rapidoid.util.Cls;
import org.rapidoid.util.English;
import org.rapidoid.util.Scan;
import org.rapidoid.util.U;
import org.rapidoid.util.UTILS;

public class AppPageGeneric
extends AppGUI {
    protected static final String[] themes = new String[]{"1", "2", "3", "4", "5"};
    protected static final Pattern ENTITY_VIEW = Pattern.compile("^/(\\w+?)/(\\d+)/?$");
    protected static final Pattern ENTITY_EDIT = Pattern.compile("^/edit(\\w+?)/(\\d+)/?$");
    protected static final Pattern ENTITY_LIST = Pattern.compile("^/(\\w+?)/?$");
    protected static final AppScreens APP_SCREENS = (AppScreens)Cls.customizable(AppScreens.class, (Object[])new Object[0]);
    protected final HttpExchange x;
    protected final AppClasses appCls;
    protected final Object app;
    protected final Object screen;

    public AppPageGeneric(HttpExchange x, AppClasses appCls) {
        this.x = x;
        this.appCls = appCls;
        this.app = AppPageGeneric.wireX(appCls.main != null ? Cls.newInstance(appCls.main) : new Object(), x);
        this.screen = AppPageGeneric.wireX(this.getScreen(), x);
        U.must((this.screen != null ? 1 : 0) != 0, (String)"Cannot find a screen to process the request!");
        Pages.load((HttpExchange)x, (Object)this.screen);
    }

    private static <T> T wireX(T target, HttpExchange x) {
        if (target instanceof HttpExchangeHolder) {
            ((HttpExchangeHolder)target).setHttpExchange(x);
        }
        return target;
    }

    public String title() {
        return Pages.titleOf((HttpExchange)this.x, (Object)this.app);
    }

    public Object head() {
        String theme = this.config("theme", null);
        return theme != null ? AppPageGeneric.link((Object[])new Object[0]).href(this.themeUrl(theme)).rel("stylesheet") : null;
    }

    protected String themeUrl(String theme) {
        if (theme.startsWith("bootswatch:")) {
            theme = theme.substring("bootswatch:".length());
            return "//maxcdn.bootstrapcdn.com/bootswatch/3.3.0/" + theme + "/bootstrap.min.css";
        }
        return "/bootstrap/css/theme-" + theme + ".css";
    }

    public Object content() {
        Map<String, Class<?>> mainScreens = this.filterScreens();
        Object pageContent = null;
        int activeIndex = -1;
        pageContent = this.pageContent();
        Class<?>[] screens = APP_SCREENS.constructScreens(mainScreens);
        List scaffolding = Scan.annotated(Scaffold.class);
        Object[] menuItems = new Object[screens.length + scaffolding.size()];
        activeIndex = this.setupMenuItems(this.x.path(), screens, menuItems, scaffolding);
        String theme = this.config("theme", null);
        ATag brand = AppPageGeneric.a((Object[])new Object[]{Pages.titleOf((HttpExchange)this.x, (Object)this.app)}).href("/");
        Tag userMenu = this.userMenu();
        Tag themesMenu = theme == null ? this.themesMenu() : null;
        Tag debugMenu = Conf.dev() ? this.debugMenu() : null;
        FormTag searchForm = this.searchForm();
        Tag navMenu = AppPageGeneric.navbarMenu((boolean)true, (int)activeIndex, (Object[])menuItems);
        Object[] navbarContent = AppPageGeneric.arr((Object[])new Tag[]{navMenu, debugMenu, themesMenu, userMenu, searchForm});
        String modal = (String)Beany.getPropValue((Object)this.screen, (String)"modal", null);
        Object modalContent = modal != null ? Beany.getPropValue((Object)this.screen, (String)modal, null) : null;
        Tag result = AppPageGeneric.navbarPage((boolean)this.isFluid(), (Tag)brand, (Object[])navbarContent, (Object)AppPageGeneric.arr((Object[])new Object[]{pageContent, modalContent}));
        Pages.store((HttpExchange)this.x, (Object)this.screen);
        return result;
    }

    protected Object genericScreen() {
        String reqType;
        String entityClass;
        Object entity;
        long id;
        String type;
        if (!this.x.query_().range().isEmpty()) {
            return null;
        }
        String path = this.x.path();
        Matcher m = ENTITY_EDIT.matcher(path);
        if (m.find()) {
            type = m.group(1);
            id = Long.parseLong(m.group(2));
            entity = DB.getIfExists((long)id);
            if (entity == null || !Metadata.isAnnotated(entity.getClass(), Scaffold.class)) {
                return null;
            }
            entityClass = Cls.entityName((Object)entity);
            if (entityClass.equals(reqType = U.capitalized((String)type))) {
                return new EditEntityScreenGeneric();
            }
        }
        if ((m = ENTITY_VIEW.matcher(path)).find()) {
            type = m.group(1);
            id = Long.parseLong(m.group(2));
            entity = DB.getIfExists((long)id);
            if (entity == null || !Metadata.isAnnotated(entity.getClass(), Scaffold.class)) {
                return null;
            }
            entityClass = Cls.entityName((Object)entity);
            if (entityClass.equals(reqType = U.capitalized((String)type))) {
                return new ViewEntityScreenGeneric();
            }
        }
        if ((m = ENTITY_LIST.matcher(path)).find()) {
            type = m.group(1);
            Class entityType = DB.schema().getEntityTypeFromPlural(type);
            if (entityType == null || !Metadata.isAnnotated((Class)entityType, Scaffold.class)) {
                return null;
            }
            return new ListEntityScreenGeneric(entityType);
        }
        return null;
    }

    protected Object pageContent() {
        Object cnt = Pages.contentOf((HttpExchange)this.x, (Object)this.screen);
        if (cnt != null) {
            return cnt;
        }
        if (this.screen != null && this.screen != this.app) {
            return "No content available!";
        }
        throw this.x.notFound();
    }

    protected FormTag searchForm() {
        return this.addon("search") ? AppPageGeneric.navbarSearchForm((String)"/search") : null;
    }

    protected boolean addon(String name) {
        return Apps.addon(this.app, name);
    }

    protected <T> T config(String name, T defaultValue) {
        return Apps.config(this.app, name, defaultValue);
    }

    protected int setupMenuItems(String currentUrl, Class<?>[] screens, Object[] menuItems, List<Class<?>> scaffolding) {
        String url;
        String title;
        Class<?> scr;
        String name;
        int i;
        int activeIndex = -1;
        int k = 0;
        for (i = 0; !(i >= screens.length || (name = Apps.screenName(scr = screens[i])).equalsIgnoreCase("about") || name.equalsIgnoreCase("help") || name.equalsIgnoreCase("settings") || name.equalsIgnoreCase("search") || name.equalsIgnoreCase("profile")); ++i) {
            title = (String)Cls.getFieldValue(scr, (String)"title", (Object)UTILS.camelPhrase((String)name));
            url = Apps.screenUrl(scr);
            menuItems[k++] = AppPageGeneric.a((Object[])new Object[]{title}).href(url);
            if (!url.equals(currentUrl)) continue;
            activeIndex = i;
        }
        for (int j = 0; j < scaffolding.size(); ++j) {
            Class<?> scaff = scaffolding.get(j);
            String name2 = English.plural((String)scaff.getSimpleName());
            String title2 = UTILS.camelSplit((String)name2);
            String url2 = "/" + name2.toLowerCase();
            menuItems[k++] = AppPageGeneric.a((Object[])new Object[]{title2}).href(url2);
            if (!url2.equals(currentUrl)) continue;
            activeIndex = i + j;
        }
        while (i < screens.length) {
            Class<?> scr2 = screens[i];
            name = Apps.screenName(scr2);
            title = (String)Cls.getFieldValue(scr2, (String)"title", (Object)UTILS.camelPhrase((String)name));
            url = Apps.screenUrl(scr2);
            menuItems[k++] = AppPageGeneric.a((Object[])new Object[]{title}).href(url);
            if (url.equals(currentUrl)) {
                activeIndex = i + scaffolding.size();
            }
            ++i;
        }
        return activeIndex;
    }

    protected Tag userMenu() {
        Tag dropdownMenu = null;
        if (this.addon("auth") || this.addon("googleLogin") || this.addon("facebookLogin") || this.addon("linkedinLogin") || this.addon("githubLogin")) {
            dropdownMenu = Secure.isLoggedIn() ? this.loggedInUserMenu() : this.loggedOutUserMenu();
        }
        return dropdownMenu;
    }

    protected Tag themesMenu() {
        ATag theme = AppPageGeneric.a_glyph((String)"eye-open", (Object[])new Object[]{"", AppPageGeneric.caret()});
        Object[] themess = new Object[themes.length];
        for (int i = 0; i < themes.length; ++i) {
            String thm = themes[i];
            String js = U.format((String)"document.cookie='THEME=%s; path=/'; location.reload();", (Object[])new Object[]{thm});
            themess[i] = AppPageGeneric.a_void((Object[])new Object[]{"Theme " + U.capitalized((String)thm)}).onclick(js);
        }
        Tag themesMenu = this.addon("themes") ? AppPageGeneric.navbarDropdown((boolean)false, (Tag)theme, (Object[])themess) : null;
        return themesMenu;
    }

    protected Tag loggedOutUserMenu() {
        ATag ga = null;
        ATag fb = null;
        ATag li = null;
        ATag gh = null;
        if (this.addon("googleLogin")) {
            ga = AppPageGeneric.a_awesome((String)"google", (Object[])new Object[]{"Sign in with Google"}).href(OAuth.getLoginURL((HttpExchange)this.x, (OAuthProvider)OAuthProvider.GOOGLE, null));
        }
        if (this.addon("facebookLogin")) {
            fb = AppPageGeneric.a_awesome((String)"facebook", (Object[])new Object[]{"Sign in with Facebook"}).href(OAuth.getLoginURL((HttpExchange)this.x, (OAuthProvider)OAuthProvider.FACEBOOK, null));
        }
        if (this.addon("linkedinLogin")) {
            li = AppPageGeneric.a_awesome((String)"linkedin", (Object[])new Object[]{"Sign in with LinkedIn"}).href(OAuth.getLoginURL((HttpExchange)this.x, (OAuthProvider)OAuthProvider.LINKEDIN, null));
        }
        if (this.addon("githubLogin")) {
            gh = AppPageGeneric.a_awesome((String)"github", (Object[])new Object[]{"Sign in with GitHub"}).href(OAuth.getLoginURL((HttpExchange)this.x, (OAuthProvider)OAuthProvider.GITHUB, null));
        }
        return AppPageGeneric.navbarDropdown((boolean)false, (Tag)AppPageGeneric.a_glyph((String)"log-in", (Object[])new Object[]{"Sign in", AppPageGeneric.caret()}), (Object[])new Object[]{ga, fb, li, gh});
    }

    protected Tag loggedInUserMenu() {
        ATag profile = AppPageGeneric.a_glyph((String)"user", (Object[])new Object[]{this.userDisplay(), AppPageGeneric.caret()});
        ATag settings = this.addon("settings") ? AppPageGeneric.a_glyph((String)"cog", (Object[])new Object[]{" Settings"}).href("/settings") : null;
        ATag logout = AppPageGeneric.a_glyph((String)"log-out", (Object[])new Object[]{"Logout"}).href("/_logout");
        return AppPageGeneric.navbarDropdown((boolean)false, (Tag)profile, (Object[])new Object[]{settings, logout});
    }

    protected String userDisplay() {
        String username = Secure.username();
        int pos = username.indexOf(64);
        return pos > 0 ? username.substring(0, pos) : username;
    }

    protected Tag debugMenu() {
        ATag debug = AppPageGeneric.a_awesome((String)"bug", (Object[])new Object[]{" ", AppPageGeneric.caret()});
        ATag userInfo = AppPageGeneric.a_awesome((String)"bug", (Object[])new Object[]{"User info"}).href("/debuguserinfo");
        ATag delAll = AppPageGeneric.a_awesome((String)"bug", (Object[])new Object[]{"Delete All Data"}).href("/deletealldata");
        return AppPageGeneric.navbarDropdown((boolean)false, (Tag)debug, (Object[])new Object[]{this.debugLoginUrl("admin"), this.debugLoginUrl("manager"), this.debugLoginUrl("moderator"), this.debugLoginUrl("foo"), this.debugLoginUrl("bar"), AppPageGeneric.menuDivider(), userInfo, AppPageGeneric.menuDivider(), delAll});
    }

    protected ATag debugLoginUrl(String username) {
        return AppPageGeneric.a_awesome((String)"bug", (Object[])new Object[]{"Sign in as " + U.capitalized((String)username)}).href("/_debugLogin?user=" + username);
    }

    protected boolean isFluid() {
        return this.config("fluid", true);
    }

    protected Object getScreen() {
        for (Class<?> screen : this.appCls.screens.values()) {
            if (!Apps.screenUrl(screen).equals(this.x.path())) continue;
            this.x.authorize(screen);
            return Cls.newInstance(screen);
        }
        return U.or((Object)this.genericScreen(), (Object)this.app);
    }

    protected Map<String, Class<?>> filterScreens() {
        Object[] screensConfig = this.config("screens", null);
        if (screensConfig == null) {
            screensConfig = this.appCls.screens.values().toArray();
        }
        LinkedHashMap filtered = new LinkedHashMap();
        for (Object scr : screensConfig) {
            Class<?> screenCls;
            if (scr instanceof Class) {
                Class cls = (Class)scr;
                screenCls = this.appCls.screens.get(cls.getSimpleName());
                if (!this.isScreenAllowed(screenCls)) continue;
                filtered.put(cls.getSimpleName(), screenCls);
                continue;
            }
            if (scr instanceof String) {
                String name = U.capitalized((String)((String)scr));
                if (!name.endsWith("Screen")) {
                    name = name + "Screen";
                }
                if (!this.isScreenAllowed(screenCls = this.appCls.screens.get(name))) continue;
                filtered.put(name, screenCls);
                continue;
            }
            throw U.rte((String)"Expected class or string to represent a screen, but found: %s", (Object[])new Object[]{scr});
        }
        return filtered;
    }

    protected boolean isScreenAllowed(Class<?> screenCls) {
        return Secure.canAccessClass((String)Secure.username(), screenCls);
    }

    public void on(String cmd, Object[] args) {
        try {
            Pages.callCmdHandler((HttpExchange)this.x, (Object)this.screen, (Cmd)new Cmd(cmd, false, args));
        }
        catch (Exception e) {
            if (UTILS.rootCause((Throwable)e) instanceof HttpExchangeException) {
                Pages.store((HttpExchange)this.x, (Object)this.screen);
            }
            throw U.rte((Throwable)e);
        }
    }
}

