/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.rapidoid.app.AppHandler;
import org.rapidoid.http.Handler;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.util.CustomizableClassLoader;
import org.rapidoid.util.IO;
import org.rapidoid.util.U;

public class AppReloadHandler
implements Handler,
Mapper<String, byte[]> {
    private final String path;

    public AppReloadHandler(String path) {
        this.path = AppReloadHandler.properPath(path);
    }

    private static String properPath(String path) {
        File dir;
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        U.must(((dir = new File(path)).exists() && dir.isDirectory() ? 1 : 0) != 0, (String)"The folder doesn't exist: %s", (Object)path);
        return path;
    }

    public Object handle(HttpExchange x) throws Exception {
        CustomizableClassLoader classLoader = new CustomizableClassLoader((Mapper)this, Predicate.ALWAYS_TRUE, true);
        AppHandler handler = new AppHandler(classLoader);
        return handler.handle(x);
    }

    public byte[] map(String classname) throws Exception {
        String filename = this.path + classname.replace('.', '/') + ".class";
        File file = new File(filename);
        if (file.exists()) {
            return IO.loadBytes((InputStream)new FileInputStream(file));
        }
        return null;
    }
}

