/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.app;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.rapidoid.annotation.Order;
import org.rapidoid.beany.Metadata;
import org.rapidoid.security.annotation.DevMode;
import org.rapidoid.util.Arr;

public class AppScreens
implements Comparator<Class<?>> {
    protected static final String SEARCH_SCREEN = "SearchScreen";
    protected static final String SETTINGS_SCREEN = "SettingsScreen";
    protected static final String ADMIN_SCREEN = "AdminScreen";
    protected static final String[] SPECIAL_SCREENS = new String[]{"SearchScreen", "SettingsScreen", "AdminScreen"};

    public Class<?>[] constructScreens(Map<String, Class<?>> mainScreens) {
        int screensN = mainScreens.size();
        for (Map.Entry<String, Class<?>> e : mainScreens.entrySet()) {
            Class<?> cls = e.getValue();
            if (!this.isSpecialScreen(cls)) continue;
            --screensN;
        }
        Class[] screens = new Class[screensN];
        int ind = 0;
        for (Map.Entry<String, Class<?>> e : mainScreens.entrySet()) {
            if (this.isSpecialScreen(e.getValue())) continue;
            screens[ind++] = e.getValue();
        }
        Arrays.sort(screens, this);
        return screens;
    }

    protected boolean isSpecialScreen(Class<?> cls) {
        return Arr.indexOf((Object[])SPECIAL_SCREENS, (Object)cls.getSimpleName()) >= 0 || Metadata.isAnnotated(cls, DevMode.class);
    }

    @Override
    public int compare(Class<?> o1, Class<?> o2) {
        int cls1 = this.screenOrder(o1);
        int cls2 = this.screenOrder(o2);
        return cls1 - cls2;
    }

    protected int screenOrder(Class<?> scrClass) {
        Order order = (Order)Metadata.classAnnotation(scrClass, Order.class);
        if (order != null) {
            return order.value();
        }
        String cls = scrClass.getSimpleName();
        if (cls.equals("HomeScreen")) {
            return -1000;
        }
        if (cls.equals("AboutScreen")) {
            return 1000;
        }
        if (cls.equals("HelpScreen")) {
            return 2000;
        }
        return 0;
    }
}

