/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.app;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.rapidoid.app.AppClasses;
import org.rapidoid.app.AppHandler;
import org.rapidoid.app.TheDefaultApp;
import org.rapidoid.beany.Beany;
import org.rapidoid.config.Conf;
import org.rapidoid.db.DB;
import org.rapidoid.http.HTTP;
import org.rapidoid.http.HTTPServer;
import org.rapidoid.http.Handler;
import org.rapidoid.http.HttpBuiltins;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.log.Log;
import org.rapidoid.oauth.OAuth;
import org.rapidoid.oauth.OAuthProvider;
import org.rapidoid.util.Cls;
import org.rapidoid.util.Scan;
import org.rapidoid.util.U;

public class Apps {
    private static AppClasses APP_CLASSES;
    public static final ConcurrentMap<String, AppClasses> CLASSES;

    public static void main(String[] args) {
        Apps.run(args);
    }

    public static void run(String ... args) {
        Conf.args((String[])args);
        Log.args((String[])args);
        Log.info((String)"Loaded database", (String)"size", (Object)DB.size());
        HTTPServer server = (HTTPServer)HTTP.server().build();
        OAuth.register((HTTPServer)server, (OAuthProvider[])new OAuthProvider[0]);
        HttpBuiltins.register((HTTPServer)server);
        server.serve((Handler)new AppHandler());
        server.start();
    }

    public static String screenName(Class<?> screenClass) {
        return U.mid((String)screenClass.getSimpleName(), (int)0, (int)-6);
    }

    public static String screenUrl(Class<?> screenClass) {
        String url = "/" + Apps.screenName(screenClass).toLowerCase();
        return url.equals("/home") ? "/" : url;
    }

    public static AppClasses scanAppClasses(HttpExchange x) {
        return Apps.scanAppClasses(x, null);
    }

    public static synchronized AppClasses scanAppClasses(HttpExchange x, ClassLoader classLoader) {
        AppClasses cls;
        String q;
        if (x.hasSession() && (q = (String)x.session("_app_classes_", null)) != null && (cls = (AppClasses)CLASSES.get(q)) != null) {
            return cls;
        }
        if (APP_CLASSES == null) {
            Map services = Cls.classMap((List)Scan.bySuffix((String)"Service", null, (ClassLoader)classLoader));
            Map pages = Cls.classMap((List)Scan.bySuffix((String)"Page", null, (ClassLoader)classLoader));
            Map apps = Cls.classMap((List)Scan.byName((String)"App", null, (ClassLoader)classLoader));
            Map screens = Cls.classMap((List)Scan.bySuffix((String)"Screen", null, (ClassLoader)classLoader));
            Class appClass = !apps.isEmpty() ? (Class)apps.get("App") : TheDefaultApp.class;
            APP_CLASSES = new AppClasses(appClass, services, pages, screens);
        }
        return APP_CLASSES;
    }

    public static <T> T config(Object obj, String configName, T byDefault) {
        Object val = Beany.getPropValue((Object)obj, (String)configName, null);
        return (T)(val != null ? val : byDefault);
    }

    public static boolean addon(Object obj, String configName) {
        return Apps.config(obj, configName, false) != false || Apps.config(obj, "full", false) != false;
    }

    public static void setAppClasses(AppClasses appClasses) {
        APP_CLASSES = appClasses;
    }

    static {
        CLASSES = U.concurrentMap();
    }
}

