/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.plugins.cache.memcached;

import java.util.List;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.BinaryConnectionFactory;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.MemcachedClient;
import org.rapidoid.plugins.cache.AbstractCachePlugin;
import org.rapidoid.plugins.cache.ICache;
import org.rapidoid.plugins.cache.memcached.MemcachedCache;
import org.rapidoid.u.U;

public class MemcachedCachePlugin
extends AbstractCachePlugin {
    private volatile MemcachedClient client;

    public MemcachedCachePlugin() {
        super("memcached");
    }

    protected void doRestart() throws Exception {
        if (this.client != null) {
            this.client.shutdown(5L, TimeUnit.SECONDS);
            this.client = null;
        }
        List servers = (List)this.option("servers", U.list((Object[])new String[]{"localhost:11211"}));
        this.client = new MemcachedClient((ConnectionFactory)new BinaryConnectionFactory(), AddrUtil.getAddresses((List)servers));
    }

    public synchronized MemcachedClient client() {
        return this.client;
    }

    public <K, V> ICache<K, V> create(String cacheName, long timeToLiveMs, boolean resetTimeToLiveWhenAccessed) {
        return new MemcachedCache(this.client, cacheName, timeToLiveMs, resetTimeToLiveWhenAccessed);
    }
}

