/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.cls;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.rapidoid.RapidoidThing;
import org.rapidoid.cls.Cls;
import org.rapidoid.cls.TypeKind;
import org.rapidoid.cls.TypeSpecificVisitor;
import org.rapidoid.commons.Err;
import org.rapidoid.u.U;

public abstract class AbstractTypeSpecificVisitor<T, R>
extends RapidoidThing
implements TypeSpecificVisitor<T, R> {
    protected R dispatch(T context, TypeKind kind, Object value) {
        switch (kind) {
            case NULL: {
                return this.processNull(context);
            }
            case UNKNOWN: {
                return this.processUnknown(context, value);
            }
            case OBJECT_ARR: {
                return this.processArray(context, (Object[])value);
            }
            case BOOLEAN: {
                return this.process(context, (boolean)((Boolean)value));
            }
            case BYTE: {
                return this.process(context, (byte)((Byte)value));
            }
            case SHORT: {
                return this.process(context, (short)((Short)value));
            }
            case CHAR: {
                return this.process(context, ((Character)value).charValue());
            }
            case INT: {
                return this.process(context, (int)((Integer)value));
            }
            case LONG: {
                return this.process(context, (long)((Long)value));
            }
            case FLOAT: {
                return this.process(context, ((Float)value).floatValue());
            }
            case DOUBLE: {
                return this.process(context, (double)((Double)value));
            }
            case STRING: {
                return this.process(context, (String)value);
            }
            case BOOLEAN_OBJ: {
                return this.process(context, (Boolean)value);
            }
            case BYTE_OBJ: {
                return this.process(context, (Byte)value);
            }
            case SHORT_OBJ: {
                return this.process(context, (Short)value);
            }
            case CHAR_OBJ: {
                return this.process(context, (Character)value);
            }
            case INT_OBJ: {
                return this.process(context, (Integer)value);
            }
            case LONG_OBJ: {
                return this.process(context, (Long)value);
            }
            case FLOAT_OBJ: {
                return this.process(context, (Float)value);
            }
            case DOUBLE_OBJ: {
                return this.process(context, (Double)value);
            }
            case DATE: {
                return this.process(context, (Date)value);
            }
            case UUID: {
                return this.process(context, (UUID)value);
            }
            case BOOLEAN_ARR: {
                return this.process(context, (boolean[])value);
            }
            case BYTE_ARR: {
                return this.process(context, (byte[])value);
            }
            case SHORT_ARR: {
                return this.process(context, (short[])value);
            }
            case CHAR_ARR: {
                return this.process(context, (char[])value);
            }
            case INT_ARR: {
                return this.process(context, (int[])value);
            }
            case LONG_ARR: {
                return this.process(context, (long[])value);
            }
            case FLOAT_ARR: {
                return this.process(context, (float[])value);
            }
            case DOUBLE_ARR: {
                return this.process(context, (double[])value);
            }
            case LIST: {
                return this.process(context, (List)value);
            }
            case SET: {
                return this.process(context, (Set)value);
            }
            case MAP: {
                return this.process(context, (Map)value);
            }
        }
        throw Err.notExpected();
    }

    @Override
    public R dispatch(T context, Object value) {
        TypeKind kind = Cls.kindOf(value);
        return this.dispatch(context, kind, value);
    }

    @Override
    public R processUnknown(T context, Object value) {
        throw U.rte((String)("Unsupported type: " + Cls.of(value).getName()));
    }

    @Override
    public R process(T context, Boolean value) {
        return this.process(context, (boolean)value);
    }

    @Override
    public R process(T context, Byte value) {
        return this.process(context, (byte)value);
    }

    @Override
    public R process(T context, Short value) {
        return this.process(context, (short)value);
    }

    @Override
    public R process(T context, Character value) {
        return this.process(context, value.charValue());
    }

    @Override
    public R process(T context, Integer value) {
        return this.process(context, (int)value);
    }

    @Override
    public R process(T context, Long value) {
        return this.process(context, (long)value);
    }

    @Override
    public R process(T context, Float value) {
        return this.process(context, value.floatValue());
    }

    @Override
    public R process(T context, Double value) {
        return this.process(context, (double)value);
    }
}

