/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.security;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Coll;
import org.rapidoid.config.Conf;
import org.rapidoid.config.Config;
import org.rapidoid.crypto.Crypto;
import org.rapidoid.u.U;

public class Auth
extends RapidoidThing {
    public static Set<String> getRolesFor(String username) {
        if (U.isEmpty((String)username)) {
            return U.set();
        }
        Config user = Conf.USERS.sub(username);
        if (user.isEmpty()) {
            return U.set();
        }
        Object roles = user.entry("roles").getOrNull();
        if (Coll.isCollection(roles)) {
            Set roleSet = U.set();
            for (String role : (Collection)roles) {
                roleSet.add(role.toLowerCase());
            }
            return roleSet;
        }
        if (roles instanceof String) {
            Set roleSet = U.set();
            for (String role : ((String)roles).toLowerCase().split("\\s*\\,\\s*")) {
                if (!U.notEmpty((String)(role = role.trim()))) continue;
                roleSet.add(role);
            }
            return roleSet;
        }
        return Collections.emptySet();
    }

    public static boolean login(String username, String password) {
        if (U.isEmpty((String)username) || password == null) {
            return false;
        }
        if (!Conf.USERS.has(username)) {
            return false;
        }
        Config user = Conf.USERS.sub(username);
        if (user.isEmpty()) {
            return false;
        }
        String pass = user.entry("password").str().getOrNull();
        String hash = user.entry("hash").str().getOrNull();
        return pass != null && U.eq((Object)password, (Object)pass) || hash != null && Crypto.passwordMatches(password, hash);
    }
}

