/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.cls;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.rapidoid.cls.TypeConstants;
import org.rapidoid.u.U;

public enum TypeKind implements TypeConstants
{
    NULL(null, false, false, true, false),
    BOOLEAN(Boolean.TYPE, true, false, true, false),
    BYTE(Byte.TYPE, true, true, true, false),
    SHORT(Short.TYPE, true, true, true, false),
    CHAR(Character.TYPE, true, true, true, false),
    INT(Integer.TYPE, true, true, true, false),
    LONG(Long.TYPE, true, true, true, false),
    FLOAT(Float.TYPE, true, true, true, false),
    DOUBLE(Double.TYPE, true, true, true, false),
    STRING(String.class, false, false, true, false),
    BOOLEAN_OBJ(Boolean.class, false, false, true, false),
    BYTE_OBJ(Byte.class, false, true, true, false),
    SHORT_OBJ(Short.class, false, true, true, false),
    CHAR_OBJ(Character.class, false, true, true, false),
    INT_OBJ(Integer.class, false, true, true, false),
    LONG_OBJ(Long.class, false, true, true, false),
    FLOAT_OBJ(Float.class, false, true, true, false),
    DOUBLE_OBJ(Double.class, false, true, true, false),
    UNKNOWN(Object.class, false, false, false, false),
    DATE(Date.class, false, false, true, false),
    UUID(UUID.class, false, false, true, false),
    BOOLEAN_ARR(boolean[].class, false, false, true, true),
    BYTE_ARR(byte[].class, false, true, true, true),
    SHORT_ARR(short[].class, false, true, true, true),
    CHAR_ARR(char[].class, false, true, true, true),
    INT_ARR(int[].class, false, true, true, true),
    LONG_ARR(long[].class, false, true, true, true),
    FLOAT_ARR(float[].class, false, true, true, true),
    DOUBLE_ARR(double[].class, false, true, true, true),
    OBJECT_ARR(Object[].class, false, false, false, true),
    LIST(List.class, false, false, false, false),
    SET(Set.class, false, false, false, false),
    MAP(Map.class, false, false, false, false);

    private static final Map<Class<?>, TypeKind> KINDS;
    private final Class<?> type;
    private final boolean primitive;
    private final boolean number;
    private final boolean concrete;
    private final boolean array;

    private static Map<Class<?>, TypeKind> initKinds() {
        Map kinds = U.map();
        for (TypeKind kind : TypeKind.values()) {
            if (kind == NULL) continue;
            kinds.put(kind.getType(), kind);
        }
        return kinds;
    }

    public static TypeKind ofType(Class<?> type) {
        if (List.class.isAssignableFrom(type)) {
            return LIST;
        }
        if (Set.class.isAssignableFrom(type)) {
            return SET;
        }
        if (Map.class.isAssignableFrom(type)) {
            return MAP;
        }
        TypeKind kind = KINDS.get(type);
        if (kind == null) {
            kind = type.isArray() ? OBJECT_ARR : UNKNOWN;
        }
        return kind;
    }

    public static TypeKind of(Object value) {
        return value != null ? TypeKind.ofType(value.getClass()) : NULL;
    }

    private TypeKind(Class<?> type, boolean primitive, boolean number, boolean concrete, boolean array) {
        this.type = type;
        this.primitive = primitive;
        this.number = number;
        this.concrete = concrete;
        this.array = array;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isNumber() {
        return this.number;
    }

    public boolean isConcrete() {
        return this.concrete;
    }

    public boolean isArray() {
        return this.array;
    }

    static {
        KINDS = TypeKind.initKinds();
    }
}

