/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.commons;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.AutoExpandingMap;
import org.rapidoid.commons.DataItems;
import org.rapidoid.commons.Err;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.u.U;

public class Coll
extends RapidoidThing {
    public static <T> Set<T> synchronizedSet(T ... values) {
        return Collections.synchronizedSet(U.set((Object[])values));
    }

    public static <T> List<T> synchronizedList(T ... values) {
        return Collections.synchronizedList(U.list((Object[])values));
    }

    public static <T> Set<T> concurrentSet() {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public static boolean isMap(Object obj) {
        return obj instanceof Map;
    }

    public static boolean isList(Object obj) {
        return obj instanceof List;
    }

    public static boolean isSet(Object obj) {
        return obj instanceof Set;
    }

    public static boolean isCollection(Object obj) {
        return obj instanceof Collection;
    }

    public static <T> void assign(Collection<T> destination, Collection<? extends T> source) {
        Err.argMust(destination != null, "destination cannot be null!", new Object[0]);
        destination.clear();
        if (source != null) {
            destination.addAll(source);
        }
    }

    public static <T> void assign(Collection<? super T> destination, T[] source) {
        Err.argMust(destination != null, "destination cannot be null!", new Object[0]);
        destination.clear();
        if (source != null) {
            Collections.addAll(destination, source);
        }
    }

    public static <K, V> void assign(Map<K, V> destination, Map<? extends K, ? extends V> source) {
        Err.argMust(destination != null, "destination cannot be null!", new Object[0]);
        destination.clear();
        if (source != null) {
            destination.putAll(source);
        }
    }

    public static <K, V> V get(Map<K, V> map, K key) {
        V value = map.get(key);
        U.notNull(value, (String)"map[%s]", (Object[])new Object[]{key});
        return value;
    }

    public static <K, V> V get(Map<K, V> map, K key, V defaultValue) {
        V value = map.get(key);
        return value != null ? value : defaultValue;
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap(Map<? extends K, ? extends V> src, boolean ignoreNullValues) {
        ConcurrentMap<K, V> map = Coll.concurrentMap();
        for (Map.Entry<K, V> e : src.entrySet()) {
            if (ignoreNullValues && e.getValue() == null) continue;
            map.put(e.getKey(), e.getValue());
        }
        return map;
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap(K key, V value) {
        ConcurrentMap<K, V> map = Coll.concurrentMap();
        map.put(key, value);
        return map;
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap(K key1, V value1, K key2, V value2) {
        ConcurrentMap<K, V> map = Coll.concurrentMap(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap(K key1, V value1, K key2, V value2, K key3, V value3) {
        ConcurrentMap<K, V> map = Coll.concurrentMap(key1, value1, key2, value2);
        map.put(key3, value3);
        return map;
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        ConcurrentMap<K, V> map = Coll.concurrentMap(key1, value1, key2, value2, key3, value3);
        map.put(key4, value4);
        return map;
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5) {
        ConcurrentMap<K, V> map = Coll.concurrentMap(key1, value1, key2, value2, key3, value3, key4, value4);
        map.put(key5, value5);
        return map;
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap(Object ... keysAndValues) {
        U.must((keysAndValues.length % 2 == 0 ? 1 : 0) != 0, (String)"Incorrect number of arguments (expected key-value pairs)!");
        ConcurrentMap<Object, Object> map = Coll.concurrentMap();
        for (int i = 0; i < keysAndValues.length / 2; ++i) {
            map.put(keysAndValues[i * 2], keysAndValues[i * 2 + 1]);
        }
        return map;
    }

    public static <K, V> Map<K, V> orderedMap() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> orderedMap(Map<? extends K, ? extends V> src, boolean ignoreNullValues) {
        Map<K, V> map = Coll.orderedMap();
        for (Map.Entry<K, V> e : src.entrySet()) {
            if (ignoreNullValues && e.getValue() == null) continue;
            map.put(e.getKey(), e.getValue());
        }
        return map;
    }

    public static <K, V> Map<K, V> orderedMap(K key, V value) {
        Map<K, V> map = Coll.orderedMap();
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> orderedMap(K key1, V value1, K key2, V value2) {
        Map<K, V> map = Coll.orderedMap(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static <K, V> Map<K, V> orderedMap(K key1, V value1, K key2, V value2, K key3, V value3) {
        Map<K, V> map = Coll.orderedMap(key1, value1, key2, value2);
        map.put(key3, value3);
        return map;
    }

    public static <K, V> Map<K, V> orderedMap(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        Map<K, V> map = Coll.orderedMap(key1, value1, key2, value2, key3, value3);
        map.put(key4, value4);
        return map;
    }

    public static <K, V> Map<K, V> orderedMap(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5) {
        Map<K, V> map = Coll.orderedMap(key1, value1, key2, value2, key3, value3, key4, value4);
        map.put(key5, value5);
        return map;
    }

    public static <K, V> Map<K, V> orderedMap(Object ... keysAndValues) {
        U.must((keysAndValues.length % 2 == 0 ? 1 : 0) != 0, (String)"Incorrect number of arguments (expected key-value pairs)!");
        Map<Object, Object> map = Coll.orderedMap();
        for (int i = 0; i < keysAndValues.length / 2; ++i) {
            map.put(keysAndValues[i * 2], keysAndValues[i * 2 + 1]);
        }
        return map;
    }

    public static <K, V> Map<K, V> synchronizedMap() {
        return Collections.synchronizedMap(U.map());
    }

    public static <T> Queue<T> queue() {
        return new ConcurrentLinkedQueue();
    }

    public static <T> BlockingQueue<T> queue(int maxSize) {
        Err.argMust(maxSize > 0, "Maximum queue size must be > 0!", new Object[0]);
        return new ArrayBlockingQueue(maxSize);
    }

    public static <K, V> Map<K, V> autoExpandingMap(final Class<?> clazz) {
        return Coll.autoExpandingMap(new Mapper<K, V>(){

            @Override
            public V map(K src) throws Exception {
                try {
                    return clazz.newInstance();
                }
                catch (Exception e) {
                    throw U.rte((Throwable)e);
                }
            }
        });
    }

    public static <K, V> Map<K, V> autoExpandingMap(Mapper<K, V> valueFactory) {
        return new AutoExpandingMap<K, V>(valueFactory);
    }

    public static <K1, K2, V> Map<K1, Map<K2, V>> mapOfMaps() {
        return Coll.autoExpandingMap(new Mapper<K1, Map<K2, V>>(){

            @Override
            public Map<K2, V> map(K1 src) throws Exception {
                return Coll.synchronizedMap();
            }
        });
    }

    public static <K1, K2, K3, V> Map<K1, Map<K2, Map<K3, V>>> mapOfMapOfMaps() {
        return Coll.autoExpandingMap(new Mapper<K1, Map<K2, Map<K3, V>>>(){

            @Override
            public Map<K2, Map<K3, V>> map(K1 src) throws Exception {
                return Coll.mapOfMaps();
            }
        });
    }

    public static <K, V> Map<K, List<V>> mapOfLists() {
        return Coll.autoExpandingMap(new Mapper<K, List<V>>(){

            @Override
            public List<V> map(K src) throws Exception {
                return Coll.synchronizedList(new Object[0]);
            }
        });
    }

    public static <K1, K2, V> Map<K1, Map<K2, List<V>>> mapOfMapOfLists() {
        return Coll.autoExpandingMap(new Mapper<K1, Map<K2, List<V>>>(){

            @Override
            public Map<K2, List<V>> map(K1 src) throws Exception {
                return Coll.mapOfLists();
            }
        });
    }

    public static <K, V> Map<K, Set<V>> mapOfSets() {
        return Coll.autoExpandingMap(new Mapper<K, Set<V>>(){

            @Override
            public Set<V> map(K src) throws Exception {
                return Coll.synchronizedSet(new Object[0]);
            }
        });
    }

    public static <K1, K2, V> Map<K1, Map<K2, Set<V>>> mapOfMapOfSets() {
        return Coll.autoExpandingMap(new Mapper<K1, Map<K2, Set<V>>>(){

            @Override
            public Map<K2, Set<V>> map(K1 src) throws Exception {
                return Coll.mapOfSets();
            }
        });
    }

    public static <T> List<T> range(Iterable<T> items, int from, int to) {
        U.must((from <= to ? 1 : 0) != 0, (String)"'from' must be <= 'to'!");
        if (from == to) {
            return Collections.emptyList();
        }
        if (items instanceof DataItems) {
            DataItems dataItems = (DataItems)items;
            return dataItems.page(from, to - from);
        }
        List list = items instanceof List ? (List)items : U.list(items);
        to = Math.min(to, list.size());
        return (List)U.cast(list.subList(from, to));
    }

    public static Integer getSizeOrNull(Iterable<?> items) {
        return items instanceof Collection ? Integer.valueOf(((Collection)items).size()) : null;
    }
}

