/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.commons;

import java.util.Set;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Coll;
import org.rapidoid.config.Conf;
import org.rapidoid.scan.ClasspathUtil;
import org.rapidoid.util.Msc;

public class Env
extends RapidoidThing {
    public static final String PROFILE_DEFAULT = "default";
    private static final Set<String> PROFILES = Coll.synchronizedSet("default");

    public static boolean production() {
        return Conf.ROOT.is("production") || Conf.ROOT.is("prod") || Env.profile("production") || Env.profile("prod");
    }

    public static boolean test() {
        return Conf.ROOT.is("test") || Env.profile("test") || Msc.insideTest();
    }

    public static boolean dev() {
        return !Env.production() && !Env.test() && !ClasspathUtil.getClasspathFolders().isEmpty();
    }

    public static Set<String> profiles() {
        if (Env.dev()) {
            PROFILES.add("dev");
        } else if (Env.test()) {
            PROFILES.add("test");
        }
        return PROFILES;
    }

    public static boolean profile(String profileName) {
        return PROFILES.contains(profileName);
    }

    public static boolean hasAnyProfile(String ... profileNames) {
        for (String profileName : profileNames) {
            if (!Env.profile(profileName)) continue;
            return true;
        }
        return false;
    }
}

