/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.commons;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Coll;
import org.rapidoid.commons.Stats;
import org.rapidoid.commons.TSValue;
import org.rapidoid.u.U;

public class TimeSeries
extends RapidoidThing {
    private static final int OVERVIEW_SIZE_THRESHOLD = 120;
    private static final long MILLIS_IN_MINUTE = 60000L;
    private static final long MILLIS_IN_HOUR = 3600000L;
    private static final long MILLIS_IN_DAY = 86400000L;
    private static final long MILLIS_IN_MONTH = 2419200000L;
    private volatile List<TSValue> values = U.list();
    private final Stats stats = new Stats();
    private final Map<Long, Stats> monthly = Coll.autoExpandingMap(Stats.class);
    private final Map<Long, Stats> daily = Coll.autoExpandingMap(Stats.class);
    private final Map<Long, Stats> hourly = Coll.autoExpandingMap(Stats.class);
    private final Map<Long, Stats> minutely = Coll.autoExpandingMap(Stats.class);
    private final Map<Long, Stats> perTenSeconds = Coll.autoExpandingMap(Stats.class);
    private final int maxSize;
    private volatile String title;

    public TimeSeries() {
        this(604800);
    }

    public TimeSeries(int maxSize) {
        this.maxSize = maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(long timestamp, double value) {
        TimeSeries timeSeries = this;
        synchronized (timeSeries) {
            TSValue ts = new TSValue(timestamp, value);
            int pos = Collections.binarySearch(this.values, ts);
            if (pos < 0) {
                pos ^= 0xFFFFFFFF;
            }
            this.values.add(pos, ts);
            if ((double)this.values.size() > (double)this.maxSize * 1.1) {
                this.values = new ArrayList<TSValue>(this.values.subList(this.values.size() - this.maxSize, this.values.size()));
            }
        }
        this.stats.add(value);
        long month = TimeSeries.month(timestamp);
        long day = TimeSeries.day(timestamp);
        long hour = TimeSeries.hour(timestamp);
        long minute = TimeSeries.minute(timestamp);
        this.monthly.get(month).add(value);
        this.daily.get(day).add(value);
        this.hourly.get(hour).add(value);
        this.minutely.get(minute).add(value);
    }

    public NavigableMap<Long, Double> values() {
        return null;
    }

    public String toString() {
        return U.frmt((String)"TimeSerie(%s)", (Object[])new Object[]{this.stats});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableMap<Long, Double> overview() {
        TimeSeries timeSeries = this;
        synchronized (timeSeries) {
            if (!this.values.isEmpty()) {
                return this.overviewOf(((TSValue)U.first(this.values)).timestamp, ((TSValue)U.last(this.values)).timestamp);
            }
            return new TreeMap<Long, Double>();
        }
    }

    public NavigableMap<Long, Double> overview(long from, long to) {
        return this.overviewOf(from, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NavigableMap<Long, Double> overviewOf(long from, long to) {
        TreeMap<Long, Double> overview = new TreeMap<Long, Double>();
        long diff = to - from;
        U.must((diff >= 0L ? 1 : 0) != 0);
        TimeSeries timeSeries = this;
        synchronized (timeSeries) {
            if (this.values.size() <= 120) {
                this.putAll(overview, this.values);
                return overview;
            }
        }
        double diffMinutes = (double)diff / 60000.0;
        double diffHours = diffMinutes / 60.0;
        double diffDays = diffHours / 24.0;
        if (diffDays > 180.0) {
            long fromMonth = TimeSeries.month(from);
            long toMonth = TimeSeries.month(to);
            for (long month = fromMonth; month <= toMonth; ++month) {
                double avg = this.monthly.get(month).avg();
                overview.put(month * 2419200000L, avg);
            }
            return overview;
        }
        if (diffDays > 15.0) {
            long fromDay = TimeSeries.day(from);
            long toDay = TimeSeries.day(to);
            for (long day = fromDay; day <= toDay; ++day) {
                double avg = this.daily.get(day).avg();
                overview.put(day * 86400000L, avg);
            }
            return overview;
        }
        if (diffDays > 0.25) {
            long fromHour = TimeSeries.hour(from);
            long toHour = TimeSeries.hour(to);
            for (long hour = fromHour; hour <= toHour; ++hour) {
                double avg = this.hourly.get(hour).avg();
                overview.put(hour * 3600000L, avg);
            }
            return overview;
        }
        if (diffMinutes > 30.0) {
            long fromMinute = TimeSeries.minute(from);
            long toMinute = TimeSeries.minute(to);
            for (long minute = fromMinute; minute <= toMinute; ++minute) {
                double avg = this.minutely.get(minute).avg();
                overview.put(minute * 60000L, avg);
            }
            return overview;
        }
        TimeSeries timeSeries2 = this;
        synchronized (timeSeries2) {
            int pos2;
            int pos1 = Collections.binarySearch(this.values, new TSValue(from, 0.0));
            if (pos1 < 0) {
                pos1 ^= 0xFFFFFFFF;
            }
            if ((pos2 = Collections.binarySearch(this.values, new TSValue(to, 0.0))) < 0) {
                pos2 ^= 0xFFFFFFFF;
            }
            List<TSValue> sub = pos1 <= pos2 ? this.values.subList(pos1, pos2) : this.values.subList(pos2, pos1);
            this.putAll(overview, sub);
        }
        return overview;
    }

    private void putAll(Map<Long, Double> dest, List<TSValue> src) {
        for (TSValue ts : src) {
            dest.put(ts.timestamp, ts.value);
        }
    }

    private static long month(long timestamp) {
        return timestamp / 2419200000L;
    }

    private static long day(long timestamp) {
        return timestamp / 86400000L;
    }

    private static long hour(long timestamp) {
        return timestamp / 3600000L;
    }

    private static long minute(long timestamp) {
        return timestamp / 60000L;
    }

    public TimeSeries title(String title) {
        this.title = title;
        return this;
    }

    public String title() {
        return this.title;
    }
}

