/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.config;

import java.util.List;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Str;
import org.rapidoid.config.Config;
import org.rapidoid.config.ConfigParser;
import org.rapidoid.data.YAML;
import org.rapidoid.io.Res;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class ConfigUtil
extends RapidoidThing {
    private static final ConfigParser YAML_PARSER = new ConfigParser(){

        @Override
        public Map<String, Object> parse(byte[] bytes) {
            return YAML.parse(bytes, Map.class);
        }
    };
    private static final Map<List<String>, Res> tracking = U.map();

    public static synchronized void autoRefresh(Config config, String yamlFilename) {
        ConfigUtil.autoRefresh(config, yamlFilename, YAML_PARSER);
    }

    public static synchronized void autoRefresh(final Config config, final String filename, final ConfigParser parser) {
        Log.debug((String)"Initializing auto-refreshing config", (String)"filename", (Object)filename);
        final Res res = Res.from(filename, new String[0]);
        tracking.put(config.keys(), res);
        Runnable reload = new Runnable(){

            @Override
            public void run() {
                Map<String, Object> configData = null;
                byte[] bytes = res.getBytesOrNull();
                if (bytes != null) {
                    if (bytes.length > 0) {
                        configData = parser.parse(bytes);
                    }
                    Log.info((String)"Loading (refreshing) configuration file", (String)"filename", (Object)filename);
                    config.update(U.safe(configData));
                } else {
                    Log.trace((String)"Couldn't find configuration file", (String)"filename", (Object)filename);
                }
            }
        };
        reload.run();
        res.onChange("config", reload);
        res.trackChanges();
        res.exists();
    }

    public static synchronized List<List<String>> untrack() {
        List keys = U.list();
        for (Map.Entry<List<String>, Res> e : tracking.entrySet()) {
            keys.add(e.getKey());
            e.getValue().removeChangeListener("config");
        }
        tracking.clear();
        return keys;
    }

    public static synchronized void load(String filename, Config config) {
        byte[] bytes = ConfigUtil.tryToLoad(filename, config);
        if (bytes != null) {
            if (bytes.length > 0) {
                Map<String, Object> configData = YAML_PARSER.parse(bytes);
                Log.debug((String)"Loading configuration file", (String)"filename", (Object)filename);
                config.update(U.safe(configData));
            }
        } else {
            Log.trace((String)"Couldn't find configuration file", (String)"filename", (Object)filename);
        }
    }

    private static byte[] tryToLoad(String filename, Config config) {
        if (filename.endsWith(".y?ml")) {
            String basename = Str.trimr(filename, ".y?ml");
            byte[] bytes = Res.from(basename + ".yaml", new String[0]).getBytesOrNull();
            if (bytes != null) {
                return bytes;
            }
            return Res.from(basename + ".yml", new String[0]).getBytesOrNull();
        }
        return Res.from(filename, new String[0]).getBytesOrNull();
    }
}

