/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.scan;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import org.rapidoid.RapidoidThing;
import org.rapidoid.cls.Cls;
import org.rapidoid.commons.Str;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.log.Log;
import org.rapidoid.scan.ScanParams;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class ClasspathUtil
extends RapidoidThing {
    private static final Set<String> CLASSPATH = new TreeSet<String>();
    private static volatile String appJar;
    private static volatile String rootPackage;
    private static volatile ClassLoader defaultClassLoader;

    private ClasspathUtil() {
    }

    public static synchronized void reset() {
        CLASSPATH.clear();
        appJar = null;
    }

    public static synchronized List<File> files(String packageName, Predicate<File> filter) {
        ArrayList<File> files = new ArrayList<File>();
        ClasspathUtil.files(packageName, files, filter);
        return files;
    }

    public static synchronized List<File> dir(String dir, Predicate<File> filter) {
        ArrayList<File> files = new ArrayList<File>();
        ClasspathUtil.getFiles(files, new File(dir), filter);
        return files;
    }

    public static synchronized void files(String packageName, Collection<File> files, Predicate<File> filter) {
        Enumeration<URL> urls = ClasspathUtil.resources(packageName);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            File file = new File(url.getFile());
            ClasspathUtil.getFiles(files, file, filter);
        }
    }

    private static void getFiles(Collection<File> files, File file, Predicate<File> filter) {
        if (file.isDirectory()) {
            Log.trace((String)"scanning directory", (String)"dir", (Object)file);
            for (File f : file.listFiles()) {
                if (f.isDirectory()) {
                    ClasspathUtil.getFiles(files, f, filter);
                    continue;
                }
                Log.trace((String)"scanned file", (String)"file", (Object)f);
                try {
                    if (filter != null && !filter.eval(f)) continue;
                    files.add(f);
                }
                catch (Exception e) {
                    throw U.rte((Throwable)e);
                }
            }
        }
    }

    public static List<String> scanClasses(ScanParams params) {
        Pattern pattern;
        Object[] pkgs = params.in();
        if (U.isEmpty((Object[])pkgs)) {
            pkgs = new String[]{rootPackage};
        }
        long startingAt = U.time();
        String regex = params.matching();
        Pattern pattern2 = pattern = U.notEmpty((String)regex) ? Pattern.compile(regex) : null;
        if (regex != null) {
            Log.info((String)"Scanning classpath", (String)"!annotated", (Object)Msc.annotations(params.annotated()), (String)"!packages", (Object)Arrays.toString(pkgs), (String)"!matching", (Object)regex);
        } else {
            Log.info((String)"Scanning classpath", (String)"!annotated", (Object)Msc.annotations(params.annotated()), (String)"!packages", (Object)Arrays.toString(pkgs));
        }
        AtomicInteger searched = new AtomicInteger();
        List classes = U.list();
        for (Object pkg : pkgs) {
            classes.addAll(ClasspathUtil.retrieveClasses((String)pkg, params.annotated(), pattern, params.classLoader(), searched));
        }
        long timeMs = U.time() - startingAt;
        Log.info((String)"Finished classpath scan", (String)"time", (Object)(timeMs + "ms"), (String)"searched", (Object)searched.get(), (String)"!found", (Object)Msc.classNames(classes));
        return classes;
    }

    private static List<String> retrieveClasses(String packageName, Class<? extends Annotation>[] annotated, Pattern regex, ClassLoader classLoader, AtomicInteger searched) {
        List classes = U.list();
        String pkgName = U.safe((String)packageName);
        String pkgPath = pkgName.replace('.', File.separatorChar);
        Set<String> classpath = ClasspathUtil.getClasspath();
        Log.trace((String)"Starting classpath scan", (String)"package", (Object)packageName, (String)"annotated", annotated, (String)"regex", (Object)regex, (String)"loader", (Object)classLoader);
        Log.trace((String)"Classpath details", (String)"classpath", classpath);
        Set jars = U.set();
        for (String cpe : classpath) {
            File cpEntry = new File(cpe);
            if (cpEntry.exists()) {
                if (cpEntry.isDirectory()) {
                    if (ClasspathUtil.shouldScanDir(cpEntry.getAbsolutePath())) {
                        Log.trace((String)"Scanning directory", (String)"root", (Object)cpEntry.getAbsolutePath());
                        File startingDir = pkgPath.isEmpty() ? cpEntry : new File(cpEntry.getAbsolutePath(), pkgPath);
                        if (!startingDir.exists()) continue;
                        ClasspathUtil.getClassesFromDir(classes, cpEntry, startingDir, pkgName, regex, annotated, classLoader, searched);
                        continue;
                    }
                    Log.trace((String)"Skipping directory", (String)"root", (Object)cpEntry.getAbsolutePath());
                    continue;
                }
                if (cpEntry.isFile() && cpEntry.getAbsolutePath().toLowerCase().endsWith(".jar")) {
                    jars.add(cpEntry.getAbsolutePath());
                    continue;
                }
                Log.warn((String)("Invalid classpath entry: " + cpe));
                continue;
            }
            Log.warn((String)("Classpath entry doesn't exist: " + cpe));
        }
        for (String jarName : jars) {
            if (ClasspathUtil.shouldScanJAR(jarName)) {
                Log.trace((String)"Scanning JAR", (String)"name", (Object)jarName);
                ClasspathUtil.getClassesFromJAR(jarName, classes, packageName, regex, annotated, classLoader, searched);
                continue;
            }
            Log.trace((String)"Skipping JAR", (String)"name", (Object)jarName);
        }
        return classes;
    }

    private static boolean shouldScanDir(String dir) {
        return true;
    }

    private static boolean shouldScanJAR(String jar) {
        return !ClasspathUtil.hasAppJar() || U.eq((Object)jar, (Object)appJar);
    }

    private static void getClassesFromDir(Collection<String> classes, File root, File dir, String pkg, Pattern regex, Class<? extends Annotation>[] annotated, ClassLoader classLoader, AtomicInteger searched) {
        U.must((boolean)dir.isDirectory());
        Log.trace((String)"Traversing directory", (String)"root", (Object)root, (String)"dir", (Object)dir);
        File[] files = dir.listFiles();
        if (files == null) {
            Log.warn((String)"Not a folder!", (String)"dir", (Object)dir);
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                ClasspathUtil.getClassesFromDir(classes, root, file, pkg, regex, annotated, classLoader, searched);
                continue;
            }
            String rootPath = Str.trimr(root.getAbsolutePath(), File.separatorChar);
            int from = rootPath.length() + 1;
            String relName = file.getAbsolutePath().substring(from);
            if (ClasspathUtil.ignore(relName)) continue;
            ClasspathUtil.scanFile(classes, regex, annotated, classLoader, relName, file, null, null, searched);
        }
    }

    private static void scanFile(Collection<String> classes, Pattern regex, Class<? extends Annotation>[] annotated, ClassLoader classLoader, String relName, File file, ZipFile zip, ZipEntry entry, AtomicInteger searched) {
        Log.trace((String)"scanned file", (String)"file", (Object)relName);
        if (relName.endsWith(".class")) {
            searched.incrementAndGet();
            String clsName = Str.sub(relName, 0, -6).replace('/', '.').replace('\\', '.');
            if (U.isEmpty((Object)regex) || regex.matcher(clsName).matches()) {
                try {
                    InputStream input = file != null ? new FileInputStream(file) : zip.getInputStream(entry);
                    ClassFile classFile = new ClassFile(new DataInputStream(input));
                    if (U.isEmpty((Object[])annotated) || ClasspathUtil.isAnnotated(classFile, annotated)) {
                        classes.add(clsName);
                    }
                }
                catch (Throwable e) {
                    Log.debug((String)"Error while loading class", (String)"name", (Object)clsName, (String)"error", (Object)e);
                }
            }
        }
    }

    private static boolean isAnnotated(ClassFile cfile, Class<? extends Annotation>[] annotated) throws IOException {
        List attributes = U.safe((List)cfile.getAttributes());
        for (Object attribute : attributes) {
            if (!(attribute instanceof AnnotationsAttribute)) continue;
            AnnotationsAttribute annotations = (AnnotationsAttribute)attribute;
            for (Class<? extends Annotation> ann : annotated) {
                if (annotations.getAnnotation(ann.getName()) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static String pkgToPath(String pkg) {
        return pkg != null ? pkg.replace('.', File.separatorChar) : null;
    }

    private static Enumeration<URL> resources(String name) {
        name = name.replace('.', '/');
        try {
            return Cls.classLoader().getResources(name);
        }
        catch (IOException e) {
            throw U.rte((String)("Cannot scan: " + name), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getClassesFromJAR(String jarName, List<String> classes, String pkg, Pattern regex, Class<? extends Annotation>[] annotated, ClassLoader classLoader, AtomicInteger searched) {
        ZipFile zip = null;
        try {
            String pkgPath = ClasspathUtil.pkgToPath(pkg);
            zip = new ZipFile(new File(jarName));
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                String name;
                ZipEntry zipEntry = entries.nextElement();
                if (zipEntry.isDirectory() || ClasspathUtil.ignore(name = zipEntry.getName()) || !U.isEmpty((String)pkg) && !name.startsWith(pkgPath)) continue;
                ClasspathUtil.scanFile(classes, regex, annotated, classLoader, name, null, zip, zipEntry, searched);
            }
        }
        catch (Exception e) {
            Log.error((String)("Cannot scan JAR: " + jarName), (Throwable)e);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    Log.error((String)"Couldn't close the ZIP stream!", (Throwable)e);
                }
            }
        }
        return classes;
    }

    private static boolean ignore(String name) {
        String part2;
        String pkgDirName = Str.triml(name, File.separatorChar);
        int p1 = pkgDirName.indexOf(File.separatorChar);
        int p2 = -1;
        return p1 > 0 && (p2 = pkgDirName.indexOf(File.separatorChar, p1 + 1)) > 0 && U.isEmpty((String)(part2 = pkgDirName.substring(p1 + 1, p2)));
    }

    public static synchronized Set<String> getClasspath() {
        if (CLASSPATH.isEmpty()) {
            String classpathProp = System.getProperty("java.class.path");
            if (classpathProp != null) {
                String[] classpathEntries;
                for (String cpe : classpathEntries = classpathProp.split(File.pathSeparator)) {
                    cpe = Str.trimr(cpe, '/');
                    CLASSPATH.add(new File(cpe).getAbsolutePath());
                }
            }
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            URL[] urls = ((URLClassLoader)cl).getURLs();
            for (URL url : urls) {
                String path = Msc.urlDecode(Str.trimr(url.getPath(), '/'));
                CLASSPATH.add(new File(path).getAbsolutePath());
            }
            for (String cp : CLASSPATH) {
                if (!cp.endsWith("/app.jar") && !cp.endsWith("\\app.jar")) continue;
                appJar = cp;
            }
        }
        return CLASSPATH;
    }

    public static synchronized Set<String> getClasspathFolders() {
        Set folders = U.set();
        Set<String> cps = ClasspathUtil.getClasspath();
        for (String cp : cps) {
            if (!new File(cp).isDirectory()) continue;
            folders.add(cp);
        }
        return folders;
    }

    public static synchronized Set<String> getClasspathJars() {
        Set jars = U.set();
        Set<String> cps = ClasspathUtil.getClasspath();
        for (String cp : cps) {
            if (!new File(cp).isFile() || !cp.substring(cp.length() - 4).equalsIgnoreCase(".JAR")) continue;
            jars.add(cp);
        }
        return jars;
    }

    public static String getRootPackage() {
        return rootPackage;
    }

    public static void setRootPackage(String rootPackage) {
        ClasspathUtil.rootPackage = rootPackage;
    }

    public static ClassLoader getDefaultClassLoader() {
        return defaultClassLoader;
    }

    public static void setDefaultClassLoader(ClassLoader defaultClassLoader) {
        ClasspathUtil.defaultClassLoader = defaultClassLoader;
    }

    public static List<String> getClasses(ScanParams scanParams) {
        return ClasspathUtil.scanClasses(scanParams);
    }

    public static List<Class<?>> loadClasses(ScanParams scanParams) {
        List<String> classNames = ClasspathUtil.scanClasses(scanParams);
        List classes = U.list();
        ClassLoader classLoader = (ClassLoader)U.or((Object)scanParams.classLoader(), (Object)defaultClassLoader);
        for (String clsName : classNames) {
            try {
                Log.trace((String)"Loading class", (String)"name", (Object)clsName);
                classes.add(classLoader != null ? Class.forName(clsName, true, classLoader) : Class.forName(clsName));
            }
            catch (Throwable e) {
                Log.debug((String)"Error while loading class", (String)"name", (Object)clsName, (String)"error", (Object)e);
            }
        }
        return classes;
    }

    public static Class<?> loadFromJar(String clsName, String jar, ClassLoader classLoader) throws Exception {
        URL url = new File(jar).toURI().toURL();
        URLClassLoader child = new URLClassLoader(new URL[]{url}, classLoader);
        return Class.forName(clsName, true, child);
    }

    public static boolean hasAppJar() {
        ClasspathUtil.getClasspath();
        return appJar != null;
    }

    public static String appJar() {
        return appJar;
    }

    public static void appJar(String appJar) {
        ClasspathUtil.appJar = appJar;
        Log.info((String)"Setting application JAR", (String)"!appJar", (Object)appJar, (String)"exists", (Object)new File(appJar).exists());
    }

    static {
        rootPackage = null;
        defaultClassLoader = ClasspathUtil.class.getClassLoader();
    }
}

