/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.sql;

import org.rapidoid.RapidoidThing;
import org.rapidoid.config.Conf;
import org.rapidoid.config.Config;
import org.rapidoid.u.U;
import org.rapidoid.value.Value;

public class JDBCConfig
extends RapidoidThing {
    private static final Config JDBC = Conf.JDBC;
    private static final Value<String> URL = JDBC.entry("url").str();
    private static final Value<String> DRIVER = JDBC.entry("driver").str();
    private static final Value<String> USERNAME = JDBC.entry("username").str();
    private static final Value<String> PASSWORD = JDBC.entry("password").str();

    public static String url() {
        return URL.getOrNull();
    }

    public static String driver() {
        String driver = DRIVER.getOrNull();
        if (driver == null && !U.isEmpty((String)JDBCConfig.url())) {
            driver = JDBCConfig.inferDriverFromUrl(JDBCConfig.url());
        }
        return driver;
    }

    public static String username() {
        return USERNAME.getOrNull();
    }

    public static String password() {
        return PASSWORD.getOrNull();
    }

    public static String inferDriverFromUrl(String url) {
        if (url.startsWith("jdbc:mysql:")) {
            return "com.mysql.jdbc.Driver";
        }
        if (url.startsWith("jdbc:h2:")) {
            return "org.hibernate.dialect.H2Dialect";
        }
        if (url.startsWith("jdbc:hsqldb:")) {
            return "org.hsqldb.jdbc.JDBCDriver";
        }
        return null;
    }
}

