/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.rapidoid.RapidoidThing;
import org.rapidoid.activity.AbstractLoopThread;
import org.rapidoid.activity.RapidoidThread;
import org.rapidoid.activity.RapidoidThreadFactory;
import org.rapidoid.annotation.Profiles;
import org.rapidoid.annotation.Run;
import org.rapidoid.cls.Cls;
import org.rapidoid.commons.Coll;
import org.rapidoid.commons.Env;
import org.rapidoid.commons.Str;
import org.rapidoid.config.Conf;
import org.rapidoid.crypto.Crypto;
import org.rapidoid.ctx.Ctx;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.insight.Insights;
import org.rapidoid.io.IO;
import org.rapidoid.io.Res;
import org.rapidoid.lambda.Dynamic;
import org.rapidoid.lambda.F2;
import org.rapidoid.lambda.Lmbd;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.lambda.Operation;
import org.rapidoid.log.Log;
import org.rapidoid.log.LogLevel;
import org.rapidoid.sql.JDBC;
import org.rapidoid.u.U;
import org.rapidoid.util.AppInfo;
import org.rapidoid.util.Bufs;
import org.rapidoid.util.Constants;
import org.rapidoid.util.D;
import org.rapidoid.util.ErrCodeAndMsg;
import org.rapidoid.util.Usage;
import org.rapidoid.validation.InvalidData;
import org.rapidoid.wrap.BoolWrap;

public class Msc
extends RapidoidThing
implements Constants {
    public static final Set<String> SPECIAL_ERRORS = Coll.synchronizedSet(SecurityException.class.getName(), InvalidData.class.getName(), "javax.validation.ConstraintViolationException", "javax.validation.ValidationException");
    public static final Mapper<Object, Object> TRANSFORM_TO_STRING = new Mapper<Object, Object>(){

        @Override
        public Object map(Object src) throws Exception {
            return src != null ? src.toString() : null;
        }
    };
    public static final Mapper<Object, Object> TRANSFORM_TO_SIMPLE_CLASS_NAME = new Mapper<Object, Object>(){

        @Override
        public Object map(Object src) throws Exception {
            if (src == null) {
                return null;
            }
            if (src instanceof Class) {
                return ((Class)src).getSimpleName();
            }
            return src.getClass().getName() + "@" + System.identityHashCode(src);
        }
    };
    private static long measureStart;
    public static final ScheduledThreadPoolExecutor EXECUTOR;

    private Msc() {
    }

    public static byte[] serialize(Object value) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(output);
            out.writeObject(value);
            output.close();
            return output.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object deserialize(byte[] buf) {
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buf));
            Object obj = in.readObject();
            in.close();
            return obj;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void serialize(Object value, ByteBuffer buf) {
        byte[] bytes = Msc.serialize(value);
        buf.putInt(bytes.length);
        buf.put(bytes);
    }

    public static Object deserialize(ByteBuffer buf) {
        int len = buf.getInt();
        byte[] bytes = new byte[len];
        buf.get(bytes);
        return Msc.deserialize(bytes);
    }

    public static String stackTraceOf(Throwable e) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(output));
        return output.toString();
    }

    public static <T> T connect(String address, int port, F2<T, BufferedReader, DataOutputStream> protocol) {
        T resp;
        Socket socket = null;
        try {
            socket = new Socket(address, port);
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            resp = protocol.execute(in, out);
            socket.close();
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    throw U.rte((Throwable)e);
                }
            }
        }
        return resp;
    }

    public static short bytesToShort(String s) {
        ByteBuffer buf = Bufs.buf(s);
        U.must((buf.limit() == 2 ? 1 : 0) != 0);
        return buf.getShort();
    }

    public static int bytesToInt(String s) {
        ByteBuffer buf = Bufs.buf(s);
        U.must((buf.limit() == 4 ? 1 : 0) != 0);
        return buf.getInt();
    }

    public static long bytesToLong(String s) {
        ByteBuffer buf = Bufs.buf(s);
        U.must((buf.limit() == 8 ? 1 : 0) != 0);
        return buf.getLong();
    }

    public static int intFrom(byte a, byte b, byte c, byte d) {
        return (a << 24) + (b << 16) + (c << 8) + d;
    }

    public static short shortFrom(byte a, byte b) {
        return (short)((a << 8) + b);
    }

    public static boolean waitInterruption(long millis) {
        try {
            Thread.sleep(millis);
            return true;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitFor(Object obj) {
        try {
            Object object = obj;
            synchronized (object) {
                obj.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void joinThread(Thread thread) {
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void benchmark(String name, int count, Runnable runnable) {
        long start = U.time();
        for (int i = 0; i < count; ++i) {
            runnable.run();
        }
        Msc.benchmarkComplete(name, count, start);
    }

    public static void benchmark(String name, int count, Operation<Integer> operation) {
        long start = U.time();
        for (int i = 0; i < count; ++i) {
            Lmbd.call(operation, i);
        }
        Msc.benchmarkComplete(name, count, start);
    }

    public static void benchmarkComplete(String name, int count, long startTime) {
        double avg;
        long end = U.time();
        long ms = end - startTime;
        if (ms == 0L) {
            ms = 1L;
        }
        String avgs = (avg = (double)count / (double)ms) > 1.0 ? Math.round(avg) + "K" : Math.round(avg * 1000.0) + "";
        String data = String.format("%s: %s in %s ms (%s/sec)", name, count, ms, avgs);
        U.print((Object[])new Object[]{data + " | " + Insights.getCpuMemStats()});
    }

    public static void benchmarkMT(int threadsN, final String name, int count, final CountDownLatch outsideLatch, final Runnable runnable) {
        U.must((count % threadsN == 0 ? 1 : 0) != 0, (String)"The number of thread must be a factor of the total count!");
        final int countPerThread = count / threadsN;
        final CountDownLatch latch = outsideLatch != null ? outsideLatch : new CountDownLatch(threadsN);
        long time = U.time();
        final Ctx ctx = Ctxs.get();
        for (int i = 1; i <= threadsN; ++i) {
            new Thread(){

                @Override
                public void run() {
                    Ctxs.attach(ctx != null ? ctx.span() : null);
                    try {
                        Msc.benchmark(name, countPerThread, runnable);
                        if (outsideLatch == null) {
                            latch.countDown();
                        }
                    }
                    finally {
                        if (ctx != null) {
                            Ctxs.close();
                        }
                    }
                }
            }.start();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw U.rte((Throwable)e);
        }
        Msc.benchmarkComplete("avg(" + name + ")", threadsN * countPerThread, time);
    }

    public static void benchmarkMT(int threadsN, String name, int count, Runnable runnable) {
        Msc.benchmarkMT(threadsN, name, count, null, runnable);
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw U.rte((Throwable)e);
        }
    }

    public static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw U.rte((Throwable)e);
        }
    }

    public static String urlDecodeOrKeepOriginal(String s) {
        try {
            return Msc.urlDecode(s);
        }
        catch (IllegalArgumentException e) {
            return s;
        }
    }

    public static void startMeasure() {
        measureStart = U.time();
    }

    public static void endMeasure() {
        long delta = U.time() - measureStart;
        D.print(delta + " ms");
    }

    public static void endMeasure(String info) {
        long delta = U.time() - measureStart;
        D.print(info + ": " + delta + " ms");
    }

    public static void endMeasure(long count, String info) {
        long delta = U.time() - measureStart;
        long freq = Math.round(1000.0 * (double)count / (double)delta);
        D.print(U.frmt((String)"%s %s in %s ms (%s/sec)", (Object[])new Object[]{count, info, delta, freq}));
    }

    public static Throwable rootCause(Throwable e) {
        while (e.getCause() != null) {
            if (SPECIAL_ERRORS.contains(e.getClass().getName())) {
                return e;
            }
            e = e.getCause();
        }
        return e;
    }

    public static String fillIn(String template, String placeholder, String value) {
        return template.replace("{{" + placeholder + "}}", value);
    }

    public static String fillIn(String template, Object ... namesAndValues) {
        String text = template.toString();
        for (int i = 0; i < namesAndValues.length / 2; ++i) {
            String placeholder = (String)namesAndValues[i * 2];
            String value = Cls.str(namesAndValues[i * 2 + 1]);
            text = Msc.fillIn(text, placeholder, value);
        }
        return text;
    }

    public static <T> Map<String, T> lowercase(Map<String, T> map) {
        Map lower = U.map();
        for (Map.Entry<String, T> e : map.entrySet()) {
            Object val = e.getValue();
            if (val instanceof String) {
                val = ((String)val).toLowerCase();
            }
            lower.put(e.getKey().toLowerCase(), val);
        }
        return lower;
    }

    public static void multiThreaded(int threadsN, final Mapper<Integer, Void> executable) {
        final CountDownLatch latch = new CountDownLatch(threadsN);
        for (int i = 1; i <= threadsN; ++i) {
            final Integer n = i;
            new Thread(){

                @Override
                public void run() {
                    Lmbd.eval(executable, n);
                    latch.countDown();
                }
            }.start();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void multiThreaded(int threadsN, final Runnable executable) {
        Msc.multiThreaded(threadsN, new Mapper<Integer, Void>(){

            @Override
            public Void map(Integer n) throws Exception {
                executable.run();
                return null;
            }
        });
    }

    public static void append(StringBuilder sb, String separator, String value) {
        if (sb.length() > 0) {
            sb.append(separator);
        }
        sb.append(value);
    }

    public static <T extends Serializable> T serializable(Object value) {
        if (value == null || value instanceof Serializable) {
            return (T)((Serializable)value);
        }
        throw U.rte((String)("Not serializable: " + value));
    }

    public static <K, V> Map<K, V> cast(Map<?, ?> map) {
        return map;
    }

    public static RapidoidThread loop(final Runnable loop) {
        AbstractLoopThread thread = new AbstractLoopThread(){

            @Override
            protected void loop() {
                loop.run();
            }
        };
        thread.start();
        return thread;
    }

    public static Class<?> getCallingClass(Class<?> ... ignoreClasses) {
        return Msc.inferCaller(ignoreClasses);
    }

    public static String getCallingPackage(Class<?> ... ignoreClasses) {
        Class<?> callerCls = Msc.inferCaller(ignoreClasses);
        if (callerCls != null) {
            return callerCls.getPackage() != null ? callerCls.getPackage().getName() : "";
        }
        return null;
    }

    private static boolean couldBeCaller(String cls) {
        return !Cls.isRapidoidClass(cls) && !Cls.isJREClass(cls) && !Cls.isIdeOrToolClass(cls);
    }

    private static Class<?> inferCaller(Class<?> ... ignoreClasses) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        for (int i = 2; i < trace.length; ++i) {
            String cls = trace[i].getClassName();
            if (!Msc.couldBeCaller(cls) || Msc.shouldIgnore(cls, ignoreClasses)) continue;
            try {
                return Class.forName(cls);
            }
            catch (ClassNotFoundException e) {
                Log.error((String)"Couldn't load the caller class!", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static Class<?> getCallingMainClass() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        for (int i = 2; i < trace.length; ++i) {
            int modif;
            Method main;
            Class clazz;
            String cls = trace[i].getClassName();
            if (!Msc.couldBeCaller(cls) || !U.eq((Object)trace[i].getMethodName(), (Object)"main") || (clazz = Cls.getClassIfExists(cls)) == null || (main = Cls.findMethod(clazz, "main", String[].class)) == null || main.getReturnType() != Void.TYPE || main.isVarArgs() || !main.getDeclaringClass().equals(clazz) || !Modifier.isStatic(modif = main.getModifiers()) || !Modifier.isPublic(modif)) continue;
            return clazz;
        }
        return null;
    }

    private static boolean shouldIgnore(String cls, Class<?>[] ignoreClasses) {
        for (Class<?> ignoreClass : ignoreClasses) {
            if (!cls.equals(ignoreClass.getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    public static byte[] toBytes(Object obj) {
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj instanceof ByteBuffer) {
            return Bufs.buf2bytes((ByteBuffer)obj);
        }
        if (obj instanceof InputStream) {
            return IO.loadBytes((InputStream)obj);
        }
        if (obj instanceof File) {
            Res res = Res.from((File)obj, new String[0]);
            res.mustExist();
            return res.getBytes();
        }
        if (obj instanceof Res) {
            Res res = (Res)obj;
            res.mustExist();
            return res.getBytes();
        }
        return U.str((Object)obj).getBytes();
    }

    public static boolean isArray(Object value) {
        return value != null && value.getClass().isArray();
    }

    public static Object[] deleteAt(Object[] arr, int index) {
        Object[] res = new Object[arr.length - 1];
        if (index > 0) {
            System.arraycopy(arr, 0, res, 0, index);
        }
        if (index < arr.length - 1) {
            System.arraycopy(arr, index + 1, res, index, res.length - index);
        }
        return res;
    }

    public static <T> T[] expand(T[] arr, int factor) {
        int len = arr.length;
        arr = Arrays.copyOf(arr, len * factor);
        return arr;
    }

    public static <T> T[] expand(T[] arr, T item) {
        int len = arr.length;
        arr = Arrays.copyOf(arr, len + 1);
        arr[len] = item;
        return arr;
    }

    public static void wait(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new CancellationException();
        }
    }

    public static void wait(CountDownLatch latch, long timeout, TimeUnit unit) {
        try {
            latch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new CancellationException();
        }
    }

    public static boolean exists(Callable<?> accessChain) {
        try {
            return accessChain != null && accessChain.call() != null;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
    }

    public static String uri(String ... parts) {
        return "/" + Msc.constructPath("/", false, parts);
    }

    public static String path(String ... parts) {
        return Msc.constructPath(File.separator, true, parts);
    }

    private static String constructPath(String separator, boolean preserveFirstSegment, String ... parts) {
        String s = "";
        for (int i = 0; i < parts.length; ++i) {
            String part = U.safe((String)parts[i]);
            if (!preserveFirstSegment || i > 0) {
                part = Str.triml(part, "/");
            }
            if (!preserveFirstSegment || part.length() > 1 || i > 0) {
                part = Str.trimr(part, "/");
                part = Str.trimr(part, "\\");
            }
            if (U.isEmpty((String)part)) continue;
            if (!s.isEmpty() && !s.endsWith(separator)) {
                s = s + separator;
            }
            s = s + part;
        }
        return s;
    }

    public static String refinePath(String path) {
        boolean absolute = path.startsWith("/");
        path = Msc.path(path.split("/"));
        return absolute ? "/" + path : path;
    }

    public static int countNonNull(Object ... values) {
        int n = 0;
        for (Object value : values) {
            if (value == null) continue;
            ++n;
        }
        return n;
    }

    public static <T> T dynamic(final Class<T> targetInterface, final Dynamic dynamic) {
        final Object obj = new Object();
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass().equals(Object.class)) {
                    if (method.getName().equals("toString")) {
                        return targetInterface.getSimpleName() + "@" + Integer.toHexString(obj.hashCode());
                    }
                    return method.invoke(obj, args);
                }
                return dynamic.call(method, U.safe((Object[])args));
            }
        };
        return (T)Proxy.newProxyInstance(targetInterface.getClassLoader(), new Class[]{targetInterface}, handler);
    }

    public static boolean withWatchModule() {
        return Cls.getClassIfExists("org.rapidoid.io.watch.Watch") != null;
    }

    public static void terminate(final int afterSeconds) {
        Log.warn((String)("Terminating application in " + afterSeconds + " seconds..."));
        new Thread(){

            @Override
            public void run() {
                U.sleep((long)(afterSeconds * 1000));
                Msc.terminate();
            }
        }.start();
    }

    public static void terminateIfIdleFor(final int idleSeconds) {
        Log.warn((String)("Will terminate if idle for " + idleSeconds + " seconds..."));
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    U.sleep((long)500L);
                    long lastUsed = Usage.getLastAppUsedOn();
                    long idleSec = (U.time() - lastUsed) / 1000L;
                    if (idleSec < (long)idleSeconds) continue;
                    Usage.touchLastAppUsedOn();
                    Msc.terminate();
                }
            }
        }).start();
    }

    public static void terminate() {
        Log.warn((String)"Terminating application.");
        System.exit(0);
    }

    public static byte sbyte(int n) {
        return (byte)(n - 128);
    }

    public static int ubyte(byte b) {
        return b + 128;
    }

    public static void logSection(String msg) {
        Log.info((String)("!" + Str.mul("-", msg.length())));
        Log.info((String)msg);
        Log.info((String)("!" + Str.mul("-", msg.length())));
    }

    public static void logProperties(Properties props) {
        for (Map.Entry<Object, Object> p : props.entrySet()) {
            Log.info((String)"Hibernate property", (String)String.valueOf(p.getKey()), (Object)p.getValue());
        }
    }

    public static boolean hasValidation() {
        return Cls.exists("javax.validation.Validation");
    }

    public static boolean hasJPA() {
        return Cls.exists("javax.persistence.Entity");
    }

    public static boolean hasRapidoidJPA() {
        return Cls.exists("org.rapidoid.jpa.JPA");
    }

    public static boolean hasRapidoidGUI() {
        return Cls.exists("org.rapidoid.gui.GUI");
    }

    public static boolean hasRapidoidWatch() {
        return Cls.exists("org.rapidoid.reload.Reload");
    }

    public static boolean hasLogback() {
        return Cls.exists("ch.qos.logback.classic.Logger");
    }

    public static boolean isValidationError(Throwable error) {
        return error instanceof InvalidData || error.getClass().getName().startsWith("javax.validation.");
    }

    public static ErrCodeAndMsg getErrorCodeAndMsg(Throwable err) {
        String defaultMsg;
        int code;
        Throwable cause = Msc.rootCause(err);
        String msg = cause.getMessage();
        if (cause instanceof SecurityException) {
            code = 403;
            defaultMsg = "Access Denied!";
        } else if (Msc.isValidationError(cause)) {
            code = 422;
            defaultMsg = "Validation Error!";
            if (cause.getClass().getName().equals("javax.validation.ConstraintViolationException")) {
                Set violations = ((ConstraintViolationException)cause).getConstraintViolations();
                StringBuilder sb = new StringBuilder();
                sb.append("Validation failed: ");
                Iterator it = U.safe((Set)violations).iterator();
                while (it.hasNext()) {
                    ConstraintViolation v = (ConstraintViolation)it.next();
                    sb.append(v.getRootBeanClass().getSimpleName());
                    sb.append(".");
                    sb.append(v.getPropertyPath());
                    sb.append(" (");
                    sb.append(v.getMessage());
                    sb.append(")");
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                msg = sb.toString();
            }
        } else {
            code = 500;
            defaultMsg = "Internal Server Error!";
        }
        msg = (String)U.or((Object)msg, (Object)defaultMsg);
        return new ErrCodeAndMsg(code, msg);
    }

    public static <T> List<T> page(Iterable<T> items, int page, int pageSize) {
        return Coll.range(items, (page - 1) * pageSize, page * pageSize);
    }

    public static List<?> getPage(Iterable<?> items, int page, int pageSize, Integer size, BoolWrap isLastPage) {
        List<?> range;
        int pageFrom = Math.max((page - 1) * pageSize, 0);
        int pageTo = page * pageSize + 1;
        if (size != null) {
            pageTo = Math.min(pageTo, size);
        }
        boolean bl = isLastPage.value = (range = Coll.range(items, pageFrom, pageTo)).size() < pageSize + 1;
        if (!isLastPage.value && !range.isEmpty()) {
            range.remove(range.size() - 1);
        }
        return range;
    }

    public static void invokeMain(Class<?> clazz, String[] args) {
        Method main = Cls.getMethod(clazz, "main", String[].class);
        U.must((main.getReturnType() == Void.TYPE ? 1 : 0) != 0);
        Cls.invokeStatic(main, new Object[]{args});
    }

    public static void filterAndInvokeMainClasses(Object[] beans, Set<Class<?>> invoked) {
        List toInvoke = U.list();
        for (Object bean : beans) {
            Class clazz;
            U.notNull((Object)bean, (String)"bean", (Object[])new Object[0]);
            if (!(bean instanceof Class) || !Cls.isAnnotated(clazz = (Class)bean, Run.class) || invoked.contains(clazz)) continue;
            toInvoke.add(clazz);
        }
        invoked.addAll(toInvoke);
        for (Class clazz : toInvoke) {
            Msc.logSection("Invoking @Run component: " + clazz.getName());
            Msc.invokeMain(clazz, Conf.getArgs());
        }
    }

    public static String annotations(Class<? extends Annotation>[] annotations) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (annotations != null) {
            for (int i = 0; i < annotations.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("@");
                sb.append(annotations[i].getSimpleName());
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public static String classes(List<Class<?>> classes) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (classes != null) {
            for (int i = 0; i < classes.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(classes.get(i).getSimpleName());
                if (i < 100) continue;
                sb.append("...");
                break;
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public static String classNames(List<String> classes) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (classes != null) {
            for (int i = 0; i < classes.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append((String)U.last((Object[])classes.get(i).split("\\.")));
                if (i < 100) continue;
                sb.append("...");
                break;
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public static String textToId(String s) {
        s = s.replaceAll("[^0-9A-Za-z]+", "-");
        s = Str.triml(s, "-");
        s = Str.trimr(s, "-");
        s = s.toLowerCase();
        return s;
    }

    public static <T> Map<String, T> protectSensitiveInfo(Map<String, T> data, T replacement) {
        Map copy = U.map();
        for (Map.Entry<String, T> e : data.entrySet()) {
            Object value = e.getValue();
            String key = e.getKey().toLowerCase();
            if (key.contains("password") || key.contains("secret") || key.contains("token") || key.contains("private")) {
                value = replacement;
            } else if (value instanceof Map) {
                value = Msc.protectSensitiveInfo((Map)value, replacement);
            }
            copy.put(e.getKey(), value);
        }
        return copy;
    }

    public static int processId() {
        return U.num((String)ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
    }

    public static String javaVersion() {
        return System.getProperty("java.version");
    }

    public static boolean matchingProfile(Class<?> clazz) {
        Profiles profiles = clazz.getAnnotation(Profiles.class);
        return profiles == null || Env.hasAnyProfile(profiles.value());
    }

    public static boolean insideTest() {
        StackTraceElement[] trace;
        for (StackTraceElement traceElement : trace = Thread.currentThread().getStackTrace()) {
            String cls = traceElement.getClassName();
            if (!cls.startsWith("org.junit.") && !cls.startsWith("org.testng.")) continue;
            return true;
        }
        return false;
    }

    public static Thread thread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.start();
        return thread;
    }

    public static void reset() {
        Log.setLogLevel((LogLevel)LogLevel.INFO);
        Env.profiles().clear();
        Env.profiles().add("default");
        Crypto.reset();
        Res.reset();
        AppInfo.reset();
        Conf.reset();
        JDBC.reset();
    }

    static {
        EXECUTOR = new ScheduledThreadPoolExecutor(8, new RapidoidThreadFactory("utils"));
    }
}

