/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.commons;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.rapidoid.collection.Coll;
import org.rapidoid.commons.EnvMode;
import org.rapidoid.commons.Err;
import org.rapidoid.commons.Str;
import org.rapidoid.config.RapidoidInitializer;
import org.rapidoid.log.Log;
import org.rapidoid.scan.ClasspathUtil;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class Environment
extends RapidoidInitializer {
    private volatile Set<String> profiles;
    private volatile Set<String> profilesView;
    private volatile EnvMode mode;
    private volatile List<String> args;
    private volatile List<String> argsView;

    public Environment() {
        this.reset();
    }

    public Set<String> profiles() {
        this.makeSureIsInitialized();
        return this.profilesView;
    }

    public EnvMode mode() {
        this.makeSureIsInitialized();
        return this.mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeSureIsInitialized() {
        if (this.profiles == null || this.mode == null) {
            Environment environment = this;
            synchronized (environment) {
                if (this.profiles == null || this.mode == null) {
                    this.initModeAndProfiles();
                }
            }
        }
    }

    public synchronized void reset() {
        this.profiles = null;
        this.mode = null;
        this.setArgs(new String[0]);
    }

    private void initModeAndProfiles() {
        boolean dev;
        if (U.isEmpty(this.profiles)) {
            this.profiles = Coll.synchronizedSet(new String[0]);
            this.profiles.addAll(Environment.retrieveProfiles(this.args));
            this.profilesView = Collections.unmodifiableSet(this.profiles);
        }
        boolean production = this.args.contains("production") || this.profiles.contains("production");
        boolean test = this.args.contains("test") || this.profiles.contains("test");
        boolean bl = dev = this.args.contains("dev") || this.profiles.contains("dev");
        if (!(production || test || dev)) {
            this.mode = Environment.inferMode();
            Log.info((String)"No production/dev/test mode was configured, inferring mode", (String)"!mode", (Object)((Object)this.mode));
        } else {
            boolean onlyOne = !(production && dev || dev && test || production && test);
            U.must((boolean)onlyOne, (String)"Only one of the ('production', 'dev', 'test') profiles can be specified!");
            if (production) {
                this.mode = EnvMode.PRODUCTION;
            } else if (dev) {
                this.mode = EnvMode.DEV;
            } else if (test) {
                this.mode = EnvMode.TEST;
            } else {
                throw Err.notExpected();
            }
        }
        String modeProfile = this.mode.name().toLowerCase();
        this.profiles.add(modeProfile);
        Log.info((String)"Initialized environment", (String)"!mode", (Object)((Object)this.mode), (String)"!profiles", this.profiles);
    }

    private static EnvMode inferMode() {
        if (Msc.isInsideTest()) {
            return EnvMode.TEST;
        }
        return ClasspathUtil.getClasspathFolders().isEmpty() ? EnvMode.PRODUCTION : EnvMode.DEV;
    }

    private static List<String> retrieveProfiles(List<String> args) {
        String profilesArg = Environment.findProfilesArg(args);
        if (U.notEmpty((String)profilesArg)) {
            List profiles = U.list((Object[])profilesArg.split("\\s*\\,\\s*"));
            Log.info((String)"Configuring active profiles", (String)"!profiles", (Object)profiles);
            return profiles;
        }
        Log.info((String)"No profiles were specified, activating 'default' profile");
        return U.list((Object[])new String[]{"default"});
    }

    private static String findProfilesArg(List<String> args) {
        String prefix = "profiles=";
        for (String arg : args) {
            if (!arg.toLowerCase().startsWith(prefix)) continue;
            return Str.triml(arg, prefix);
        }
        return null;
    }

    public void setArgs(String ... args) {
        this.args = Coll.synchronizedList(args);
        this.argsView = Collections.unmodifiableList(this.args);
    }

    public List<String> args() {
        return this.argsView;
    }

    public boolean hasProfile(String profileName) {
        return this.profiles().contains(profileName);
    }

    public boolean hasAnyProfile(String ... profileNames) {
        for (String profileName : profileNames) {
            if (!this.hasProfile(profileName)) continue;
            return true;
        }
        return false;
    }

    public synchronized void setProfiles(String ... activeProfiles) {
        if (U.isEmpty(this.profiles)) {
            this.profiles = Coll.synchronizedSet(new String[0]);
            this.profilesView = Collections.unmodifiableSet(this.profiles);
        }
        Collections.addAll(this.profiles, activeProfiles);
        this.mode = null;
        this.initModeAndProfiles();
        Log.info((String)"Activating custom profiles", (String)"!activating", (Object)activeProfiles, (String)"!resulting profiles", this.profiles, (String)"!resulting mode", (Object)((Object)this.mode));
    }

    public boolean isInitialized() {
        return this.mode != null;
    }
}

