/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.config;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.rapidoid.RapidoidThing;
import org.rapidoid.beany.Beany;
import org.rapidoid.cls.Cls;
import org.rapidoid.collection.Coll;
import org.rapidoid.commons.Arr;
import org.rapidoid.commons.Env;
import org.rapidoid.config.Conf;
import org.rapidoid.config.Config;
import org.rapidoid.config.ConfigAlternatives;
import org.rapidoid.config.ConfigBase;
import org.rapidoid.config.ConfigLoaderUtil;
import org.rapidoid.config.ConfigUtil;
import org.rapidoid.config.ConfigValueStore;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;
import org.rapidoid.value.Value;
import org.rapidoid.value.Values;

public class ConfigImpl
extends RapidoidThing
implements Config {
    private final List<String> baseKeys;
    private final ConfigImpl root;
    private final ConfigBase base;
    private final boolean isRoot;

    public ConfigImpl() {
        this(null, false);
    }

    public ConfigImpl(String defaultFilenameBase) {
        this(defaultFilenameBase, false);
    }

    public ConfigImpl(String defaultFilenameBase, boolean useBuiltInDefaults) {
        this.base = new ConfigBase(defaultFilenameBase, useBuiltInDefaults);
        this.root = this;
        this.baseKeys = U.list();
        this.isRoot = true;
    }

    private ConfigImpl(ConfigBase base, List<String> baseKeys, ConfigImpl root) {
        this.base = base;
        this.root = root;
        this.baseKeys = Collections.unmodifiableList(U.list(baseKeys));
        this.isRoot = false;
    }

    @Override
    public synchronized void reset() {
        this.clear();
        this.base.reset();
    }

    @Override
    public void invalidate() {
        this.clear();
        this.base.invalidate();
    }

    @Override
    public Value<Object> entry(String key) {
        return Values.wrap(new ConfigValueStore(this, key));
    }

    private List<String> keyChain(Iterator<String> keys) {
        List keyChain = U.list(this.baseKeys);
        while (keys.hasNext()) {
            String key = keys.next();
            U.notNull((Object)key, (String)"config key", (Object[])new Object[0]);
            Collections.addAll(keyChain, key.split("\\."));
        }
        return keyChain;
    }

    @Override
    public Config sub(String ... keys) {
        U.must((boolean)U.notEmpty((Object[])keys), (String)"Keys must be specified!");
        return new ConfigImpl(this.base, this.keyChain(U.iterator((Object[])keys)), this.root());
    }

    @Override
    public Config sub(List<String> keys) {
        U.must((boolean)U.notEmpty(keys), (String)"Keys must be specified!");
        return new ConfigImpl(this.base, this.keyChain(keys.iterator()), this.root());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String key) {
        Object value;
        this.makeSureIsInitialized();
        Map<String, Object> map = this.base.properties;
        synchronized (map) {
            value = this.asMap().get(key);
        }
        return value != null ? value : this.global(key);
    }

    private String global(String key) {
        String fullKey = this.fullKey(key, ".");
        String value = System.getProperty(fullKey);
        if (value == null) {
            value = System.getenv(fullKey);
        }
        if (value == null) {
            value = System.getenv(this.fullKey(key, "_").toUpperCase());
        }
        if (value == null) {
            value = System.getenv(this.fullKey(key, "_").toLowerCase());
        }
        return value;
    }

    private String fullKey(String key, String separator) {
        return U.join((String)separator, this.baseKeys) + separator + key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean has(String key) {
        this.makeSureIsInitialized();
        Map<String, Object> map = this.base.properties;
        synchronized (map) {
            return this.asMap().containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean is(String key) {
        Object value;
        this.makeSureIsInitialized();
        Map<String, Object> map = this.base.properties;
        synchronized (map) {
            value = this.asMap().get(key);
        }
        return Boolean.TRUE.equals(Cls.convert(value, Boolean.class));
    }

    @Override
    public Map<String, Object> toMap() {
        this.makeSureIsInitialized();
        return Collections.unmodifiableMap(this.asMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> asMap() {
        this.makeSureIsInitialized();
        if (this.isRoot) {
            return this.base.properties;
        }
        Map<String, Object> map = this.base.properties;
        synchronized (map) {
            Map<String, Object> props = this.base.properties;
            for (String key : this.baseKeys) {
                Map value = props.get(key);
                if (value == null) {
                    value = Coll.synchronizedMap();
                    props.put(key, value);
                }
                if (value instanceof Map) {
                    props = value;
                    continue;
                }
                throw U.rte((String)"Expected a Map for configuration section '%s', but found value of type: %s", (Object[])new Object[]{this.sectionTo(key), value.getClass().getSimpleName()});
            }
            return props;
        }
    }

    private String sectionTo(String toKey) {
        String section = "";
        for (String key : this.baseKeys) {
            if (!section.isEmpty()) {
                section = section + ".";
            }
            section = section + key;
            if (!key.equals(toKey)) continue;
            break;
        }
        return section;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.isRoot) {
            this.base.properties.clear();
        } else {
            Map<String, Object> map = this.base.properties;
            synchronized (map) {
                this.parent().remove(this.lastBaseKey());
            }
        }
    }

    private String lastBaseKey() {
        return this.baseKeys.get(this.baseKeys.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, Object value) {
        this.makeSureIsInitialized();
        Map<String, Object> map = this.base.properties;
        synchronized (map) {
            this.asMap().put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        this.makeSureIsInitialized();
        Map<String, Object> map = this.base.properties;
        synchronized (map) {
            this.asMap().remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assign(Map<String, Object> entries) {
        this.makeSureIsInitialized();
        Map<String, Object> map = this.base.properties;
        synchronized (map) {
            this.clear();
            this.update(entries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.makeSureIsInitialized();
        Map<String, Object> map = this.base.properties;
        synchronized (map) {
            return this.asMap().isEmpty();
        }
    }

    @Override
    public void update(Map<String, ?> entries) {
        this.makeSureIsInitialized();
        this.update(entries, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Map<String, ?> entries, boolean overridenByEnv) {
        this.makeSureIsInitialized();
        Map<String, Object> map = this.base.properties;
        synchronized (map) {
            Map<String, Object> conf = this.asMap();
            for (Map.Entry<String, ?> e : entries.entrySet()) {
                String name = e.getKey();
                Object value = e.getValue();
                if (value instanceof Map) {
                    this.sub(name).update((Map)value, overridenByEnv);
                    continue;
                }
                if (overridenByEnv) {
                    value = U.or((Object)this.global(name), value);
                }
                conf.put(name, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.makeSureIsInitialized();
        Map<String, Object> map = this.base.properties;
        synchronized (map) {
            return this.asMap().toString();
        }
    }

    @Override
    public void args(List<String> args) {
        this.mustBeRoot();
        this.makeSureIsInitialized();
        if (U.notEmpty(args)) {
            for (String arg : args) {
                if (arg.contains("->")) continue;
                String[] parts = arg.split("=", 2);
                String name = parts[0];
                if (parts.length > 1) {
                    String value = parts[1];
                    if (name.equals("config")) {
                        this.setFilenameBase(value);
                    }
                    this.base.putArg(name, value);
                    continue;
                }
                this.base.putArg(name, true);
            }
        }
    }

    private void mustBeRoot() {
        U.must((boolean)this.isRoot, (String)"Must be Config's root!");
    }

    @Override
    public void setNested(String key, Object value) {
        Object[] keys = key.split("\\.");
        ConfigImpl cfg = keys.length > 1 ? this.sub(Arr.sub(keys, 0, -1)) : this;
        cfg.set((String)U.last((Object[])keys), value);
    }

    @Override
    public ConfigImpl root() {
        return this.root;
    }

    @Override
    public Config parent() {
        return this.isRoot ? null : this.root.sub(this.baseKeys.subList(0, this.baseKeys.size() - 1));
    }

    @Override
    public List<String> keys() {
        return this.baseKeys;
    }

    @Override
    public Map<String, String> toFlatMap() {
        this.makeSureIsInitialized();
        Map flatMap = U.map();
        Map<String, Object> map = this.toMap();
        ConfigImpl.traverseToFlat(map, U.list(this.keys()), flatMap);
        return flatMap;
    }

    private static void traverseToFlat(Map<String, Object> map, List<String> keys, Map<String, String> flatMap) {
        for (Map.Entry<String, Object> e : map.entrySet()) {
            String key = e.getKey();
            Object val = e.getValue();
            if (val instanceof Map) {
                Map mapVal = (Map)val;
                List keys2 = U.list(keys);
                keys2.add(key);
                ConfigImpl.traverseToFlat(mapVal, keys2, flatMap);
                continue;
            }
            flatMap.put(U.join((String)".", keys) + "." + key, String.valueOf(val));
        }
    }

    @Override
    public Properties toProperties() {
        this.makeSureIsInitialized();
        Properties props = new Properties();
        props.putAll(this.toFlatMap());
        return props;
    }

    @Override
    public ConfigAlternatives or(Config alternative) {
        return new ConfigAlternatives(this, alternative);
    }

    @Override
    public String getFilenameBase() {
        return this.base.getFilenameBase();
    }

    @Override
    public Config setFilenameBase(String filenameBase) {
        if (this.base.setFilenameBase(filenameBase)) {
            this.invalidate();
        }
        return this;
    }

    @Override
    public String getPath() {
        return this.base.getPath();
    }

    @Override
    public Config setPath(String path) {
        if (this.base.setPath(path)) {
            this.invalidate();
        }
        return this;
    }

    @Override
    public void applyTo(Object target) {
        this.makeSureIsInitialized();
        Beany.update(target, this.toMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeSureIsInitialized() {
        if (this.base.initializing) {
            return;
        }
        if (!this.base.initialized) {
            ConfigImpl configImpl = this;
            synchronized (configImpl) {
                if (!this.base.initialized) {
                    this.base.initializing = true;
                    this.root.initialize();
                    this.base.initialized = true;
                }
            }
        }
    }

    protected synchronized void initialize() {
        this.mustBeRoot();
        List<List<String>> detached = ConfigUtil.untrack();
        List loaded = U.list();
        this.args(Env.args());
        this.base.applyArgsTo(this);
        if (this.useBuiltInDefaults()) {
            ConfigLoaderUtil.loadBuiltInConfig(this, loaded);
        }
        ConfigLoaderUtil.loadDefaultConfig(this, loaded);
        ConfigLoaderUtil.loadConfig(this, detached, loaded);
        this.base.applyArgsTo(this);
        Conf.applyConfig(this);
        if (!loaded.isEmpty()) {
            Log.info((String)"Loaded configuration", (String)"!files", (Object)loaded);
        } else {
            Log.warn((String)"Didn't find any configuration files", (String)"path", (Object)this.getPath());
        }
    }

    @Override
    public boolean useBuiltInDefaults() {
        return this.base.useBuiltInDefaults();
    }

    @Override
    public void updateNested(Map<String, Object> properties) {
        for (Map.Entry<String, Object> prop : properties.entrySet()) {
            this.setNested(prop.getKey(), prop.getValue());
        }
    }
}

