/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.xml.bind.DatatypeConverter;
import org.netnix.AES;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Str;
import org.rapidoid.config.Conf;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class Crypto
extends RapidoidThing {
    public static final SecureRandom RANDOM = new SecureRandom();
    private static volatile byte[] secretKey;
    private static final byte[] DEFAULT_PBKDF2_SALT;

    public static void reset() {
        secretKey = null;
    }

    public static MessageDigest digest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw U.rte((String)("Cannot find crypto algorithm: " + algorithm));
        }
    }

    public static Cipher cipher(String transformation) {
        try {
            return Cipher.getInstance(transformation);
        }
        catch (NoSuchAlgorithmException e) {
            throw U.rte((String)("Cannot find crypto algorithm: " + transformation));
        }
        catch (NoSuchPaddingException e) {
            throw U.rte((String)("No such padding: " + transformation));
        }
    }

    public static String bytesAsText(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static byte[] md5Bytes(byte[] bytes) {
        MessageDigest md5 = Crypto.digest("MD5");
        md5.update(bytes);
        return md5.digest();
    }

    public static String md5(byte[] bytes) {
        return Crypto.bytesAsText(Crypto.md5Bytes(bytes));
    }

    public static String md5(String data) {
        return Crypto.md5(data.getBytes());
    }

    public static byte[] sha1Bytes(byte[] bytes) {
        MessageDigest sha1 = Crypto.digest("SHA-1");
        sha1.update(bytes);
        return sha1.digest();
    }

    public static String sha1(byte[] bytes) {
        return Crypto.bytesAsText(Crypto.sha1Bytes(bytes));
    }

    public static String sha1(String data) {
        return Crypto.sha1(data.getBytes());
    }

    public static byte[] sha512Bytes(byte[] bytes) {
        MessageDigest sha1 = Crypto.digest("SHA-512");
        sha1.update(bytes);
        return sha1.digest();
    }

    public static String sha512(byte[] bytes) {
        return Crypto.bytesAsText(Crypto.sha512Bytes(bytes));
    }

    public static String sha512(String data) {
        return Crypto.sha512(data.getBytes());
    }

    public static synchronized byte[] getSecretKey() {
        if (secretKey == null) {
            Crypto.initSecret();
        }
        U.notNull((Object)secretKey, (String)"app secret key", (Object[])new Object[0]);
        return secretKey;
    }

    private static synchronized void initSecret() {
        String secret = Conf.ROOT.entry("secret").str().getOrNull();
        if (secret == null) {
            Log.warn((String)"!Application secret was not specified, generating random secret!");
            byte[] rnd = new byte[128];
            RANDOM.nextBytes(rnd);
            secretKey = Crypto.pbkdf2(Str.toHex(rnd));
        } else {
            secretKey = Crypto.pbkdf2(secret);
        }
    }

    public static byte[] randomBytes(int byteCount) {
        byte[] bytes = new byte[byteCount];
        RANDOM.nextBytes(bytes);
        return bytes;
    }

    public static String randomStr(int byteCount) {
        return DatatypeConverter.printHexBinary((byte[])Crypto.randomBytes(byteCount));
    }

    public static byte[] encrypt(byte[] data, byte[] secret) {
        try {
            return AES.encrypt(data, secret);
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
    }

    public static byte[] decrypt(byte[] data, byte[] secret) {
        try {
            return AES.decrypt(data, secret);
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
    }

    public static byte[] encrypt(byte[] data) {
        return Crypto.encrypt(data, Crypto.getSecretKey());
    }

    public static byte[] decrypt(byte[] data) {
        return Crypto.decrypt(data, Crypto.getSecretKey());
    }

    public static byte[] pbkdf2(String password, byte[] salt, int iterations, int length) {
        try {
            return AES.generateKey(password, salt, iterations, length);
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
    }

    public static byte[] pbkdf2(String password) {
        return Crypto.pbkdf2(password, DEFAULT_PBKDF2_SALT, 100000, 256);
    }

    public static String passwordHash(String password) {
        return Crypto.passwordHash(password, 100000);
    }

    public static String passwordHash(String password, int iterations) {
        return Crypto.passwordHash(password, iterations, Crypto.randomSalt());
    }

    public static String passwordHash(String password, int iterations, byte[] salt) {
        byte[] hash = Crypto.pbkdf2(password, salt, iterations, 256);
        return Str.toBase64(hash) + "$" + Str.toBase64(salt) + "$" + iterations;
    }

    public static boolean passwordMatches(String password, String saltedHash) {
        int iterations;
        String[] parts = saltedHash.split("\\$");
        if (parts.length != 3) {
            return false;
        }
        byte[] expectedHash = Str.fromBase64(parts[0]);
        byte[] salt = Str.fromBase64(parts[1]);
        try {
            iterations = U.num((String)parts[2]);
        }
        catch (Exception e) {
            return false;
        }
        byte[] realHash = Crypto.pbkdf2(password, salt, iterations, 256);
        return Arrays.equals(expectedHash, realHash);
    }

    public static byte[] randomSalt() {
        byte[] salt = new byte[20];
        RANDOM.nextBytes(salt);
        return salt;
    }

    static {
        DEFAULT_PBKDF2_SALT = new byte[]{0, -3, -76, 48, 23, 1, 43, -41, -120, 45, -92, -113, -100, 70, -68, -46, 96, -93, 15, 99};
    }
}

