/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.pool;

import java.util.concurrent.Callable;
import org.rapidoid.pool.ArrayPool;
import org.rapidoid.pool.Pool;
import org.rapidoid.pool.SynchronizedArrayPool;

public class ThreadSafeArrayPool<T>
extends ArrayPool<T> {
    private final Thread ownerThread = Thread.currentThread();
    private final Pool<T> synchronizedPool;

    public ThreadSafeArrayPool(String name, Callable<T> factory, int capacity) {
        super(name, factory, capacity);
        this.synchronizedPool = new SynchronizedArrayPool<T>(name, factory, capacity);
    }

    @Override
    public T get() {
        if (Thread.currentThread() == this.ownerThread && super.size() > 0) {
            return super.get();
        }
        return this.synchronizedPool.get();
    }

    @Override
    public void release(T obj) {
        if (Thread.currentThread() == this.ownerThread) {
            super.release(obj);
        } else {
            this.synchronizedPool.release(obj);
        }
    }

    @Override
    public int objectsCreated() {
        return super.objectsCreated() + this.synchronizedPool.objectsCreated();
    }

    @Override
    public int size() {
        return super.size() + this.synchronizedPool.size();
    }

    @Override
    public void clear() {
        super.clear();
        this.synchronizedPool.clear();
    }
}

