/*
 * Decompiled with CFR 0.152.
 */
package org.netnix;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import keywhiz.hkdf.Hkdf;
import org.rapidoid.crypto.Crypto;
import org.rapidoid.u.U;

public class AES {
    private static final Hkdf HKDF = Hkdf.usingDefaults();
    private static final String HMAC_SHA_256 = "HmacSHA256";
    private static final String AES_CTR_NO_PADDING = "AES/CTR/NoPadding";
    public static final int AES_KEY_LENGTH = AES.calcAESKeyLength();

    private static int calcAESKeyLength() {
        int maxKeyLen;
        try {
            maxKeyLen = Cipher.getMaxAllowedKeyLength("AES");
        }
        catch (NoSuchAlgorithmException e) {
            throw U.rte((Throwable)e);
        }
        return maxKeyLen > 256 ? 256 : 128;
    }

    public static byte[] generateKey(String password, byte[] salt, int iterations, int length) throws Exception {
        SecretKeyFactory skf = AES.getPBKDFInstance();
        PBEKeySpec ks = new PBEKeySpec(password.toCharArray(), salt, iterations, length);
        return skf.generateSecret(ks).getEncoded();
    }

    private static SecretKeyFactory getPBKDFInstance() throws NoSuchAlgorithmException {
        try {
            return SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            return SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        }
    }

    public static byte[] encrypt(byte[] data, byte[] secret) throws Exception {
        byte[] aesSalt = Crypto.randomSalt();
        byte[] aesKey = AES.hkdf(secret, aesSalt, AES_KEY_LENGTH);
        SecretKeySpec aesKeySpec = new SecretKeySpec(aesKey, "AES");
        Cipher cipher = Cipher.getInstance(AES_CTR_NO_PADDING);
        cipher.init(1, (Key)aesKeySpec, new IvParameterSpec(new byte[16]));
        byte[] encrypted = cipher.doFinal(data);
        byte[] hmacSalt = Crypto.randomSalt();
        byte[] hmacKey = AES.hkdf(secret, hmacSalt, 160);
        SecretKeySpec hmacKeySpec = new SecretKeySpec(hmacKey, HMAC_SHA_256);
        Mac m = Mac.getInstance(HMAC_SHA_256);
        m.init(hmacKeySpec);
        byte[] hmac = m.doFinal(encrypted);
        byte[] os = new byte[40 + encrypted.length + 32];
        System.arraycopy(aesSalt, 0, os, 0, 20);
        System.arraycopy(hmacSalt, 0, os, 20, 20);
        System.arraycopy(encrypted, 0, os, 40, encrypted.length);
        System.arraycopy(hmac, 0, os, 40 + encrypted.length, 32);
        return os;
    }

    public static byte[] decrypt(byte[] data, byte[] secret) throws Exception {
        U.must((data.length >= 72 ? 1 : 0) != 0, (String)"Not enough data to decrypt!");
        byte[] aesSalt = Arrays.copyOfRange(data, 0, 20);
        byte[] hmacSalt = Arrays.copyOfRange(data, 20, 40);
        byte[] encrypted = Arrays.copyOfRange(data, 40, data.length - 32);
        byte[] hmac = Arrays.copyOfRange(data, data.length - 32, data.length);
        byte[] hmacKey = AES.hkdf(secret, hmacSalt, 160);
        SecretKeySpec hmacKeySpec = new SecretKeySpec(hmacKey, HMAC_SHA_256);
        Mac m = Mac.getInstance(HMAC_SHA_256);
        m.init(hmacKeySpec);
        byte[] expectedHmac = m.doFinal(encrypted);
        if (Arrays.equals(hmac, expectedHmac)) {
            byte[] decrKey = AES.hkdf(secret, aesSalt, AES_KEY_LENGTH);
            SecretKeySpec dekrKeySpec = new SecretKeySpec(decrKey, "AES");
            Cipher cipher = Cipher.getInstance(AES_CTR_NO_PADDING);
            cipher.init(2, (Key)dekrKeySpec, new IvParameterSpec(new byte[16]));
            return cipher.doFinal(encrypted);
        }
        throw U.rte((String)"Cannot decrypt corrupted data!");
    }

    private static byte[] hkdf(byte[] secret, byte[] salt, int bitLength) {
        SecretKeySpec key = new SecretKeySpec(secret, HMAC_SHA_256);
        return HKDF.expand(key, salt, bitLength / 8);
    }
}

