/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.concurrent;

import java.util.concurrent.CountDownLatch;
import org.rapidoid.RapidoidThing;
import org.rapidoid.concurrent.Callback;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.log.Log;

public class Callbacks
extends RapidoidThing {
    public static <T> void done(Callback<T> callback, T result, Throwable error) {
        if (callback != null) {
            try {
                callback.onDone(result, error);
            }
            catch (Exception e) {
                Log.error((String)"Callback error", (Throwable)e);
            }
        }
    }

    public static <T> void success(Callback<T> callback, T result) {
        Callbacks.done(callback, result, null);
    }

    public static <T> void error(Callback<T> callback, Throwable error) {
        Callbacks.done(callback, null, error);
    }

    public static <FROM, TO> Callback<FROM> mapping(final Callback<TO> callback, final Mapper<FROM, TO> mapper) {
        return new Callback<FROM>(){

            @Override
            public void onDone(FROM result, Throwable error) throws Exception {
                Object mapped = error == null ? (Object)mapper.map(result) : null;
                Callbacks.done(callback, mapped, error);
            }
        };
    }

    public static <T> Callback<T> countDown(final CountDownLatch latch) {
        return new Callback<T>(){

            @Override
            public void onDone(T result, Throwable error) throws Exception {
                latch.countDown();
            }
        };
    }
}

