/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.config;

import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.collection.Coll;
import org.rapidoid.commons.Env;
import org.rapidoid.config.Config;
import org.rapidoid.config.ConfigImpl;
import org.rapidoid.io.Res;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.log.Log;
import org.rapidoid.scan.ClasspathUtil;
import org.rapidoid.u.U;

public class Conf
extends RapidoidThing {
    private static final Map<String, Config> SECTIONS = Coll.autoExpandingMap(new Mapper<String, Config>(){

        @Override
        public Config map(String name) throws Exception {
            return Conf.createSection(name);
        }
    });
    public static final Config ROOT = new ConfigImpl("config", true);
    public static final Config USERS = Conf.section("users");
    public static final Config JOBS = Conf.section("jobs");
    public static final Config OAUTH = Conf.section("oauth");
    public static final Config JDBC = Conf.section("jdbc");
    public static final Config HIBERNATE = Conf.section("hibernate");
    public static final Config C3P0 = Conf.section("c3p0");
    public static final Config APP = Conf.section("app");
    public static final Config HTTP = Conf.section("http");
    public static final Config ON = Conf.section("on");
    public static final Config ADMIN = Conf.section("admin");
    public static final Config TOKEN = Conf.section("token");

    static void applyConfig(Config config) {
        if (Env.isInitialized() && !Env.production()) {
            Log.setStyled((boolean)true);
        }
        if (config == ROOT) {
            boolean fancy;
            String root;
            String appJar = APP.entry("jar").str().getOrNull();
            if (U.notEmpty((String)appJar)) {
                ClasspathUtil.appJar(appJar);
            }
            if (U.notEmpty((String)(root = ROOT.entry("root").str().getOrNull()))) {
                Res.root(root);
            }
            if (fancy = ROOT.entry("fancy").bool().or(false).booleanValue()) {
                Log.setStyled((boolean)true);
            }
        }
    }

    public static synchronized void reset() {
        ROOT.reset();
    }

    public static synchronized Config section(String name) {
        return SECTIONS.get(name);
    }

    public static synchronized Config section(Class<?> clazz) {
        return Conf.section(clazz.getSimpleName());
    }

    private static Config createSection(String name) {
        return ROOT.sub(name);
    }
}

