/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.cls;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.rapidoid.RapidoidThing;
import org.rapidoid.cls.Cls;
import org.rapidoid.cls.TypeKind;
import org.rapidoid.cls.TypeSpecificVisitor;
import org.rapidoid.commons.Err;
import org.rapidoid.u.U;

public abstract class AbstractTypeSpecificVisitor<T, R>
extends RapidoidThing
implements TypeSpecificVisitor<T, R> {
    protected R dispatch(T context, TypeKind kind, Object value) {
        switch (kind) {
            case NULL: {
                return (R)this.processNull(context);
            }
            case UNKNOWN: {
                return this.processUnknown(context, value);
            }
            case OBJECT_ARR: {
                return (R)this.processArray(context, (Object[])value);
            }
            case BOOLEAN: {
                return (R)this.process(context, (Boolean)value);
            }
            case BYTE: {
                return (R)this.process(context, (Byte)value);
            }
            case SHORT: {
                return (R)this.process(context, (Short)value);
            }
            case CHAR: {
                return (R)this.process(context, ((Character)value).charValue());
            }
            case INT: {
                return (R)this.process(context, (Integer)value);
            }
            case LONG: {
                return (R)this.process(context, (Long)value);
            }
            case FLOAT: {
                return (R)this.process(context, ((Float)value).floatValue());
            }
            case DOUBLE: {
                return (R)this.process(context, (Double)value);
            }
            case STRING: {
                return (R)this.process(context, (String)value);
            }
            case BOOLEAN_OBJ: {
                return this.process(context, (Boolean)value);
            }
            case BYTE_OBJ: {
                return this.process(context, (Byte)value);
            }
            case SHORT_OBJ: {
                return this.process(context, (Short)value);
            }
            case CHAR_OBJ: {
                return this.process(context, (Character)value);
            }
            case INT_OBJ: {
                return this.process(context, (Integer)value);
            }
            case LONG_OBJ: {
                return this.process(context, (Long)value);
            }
            case FLOAT_OBJ: {
                return this.process(context, (Float)value);
            }
            case DOUBLE_OBJ: {
                return this.process(context, (Double)value);
            }
            case DATE: {
                return (R)this.process(context, (Date)value);
            }
            case UUID: {
                return (R)this.process(context, (UUID)value);
            }
            case BOOLEAN_ARR: {
                return (R)this.process(context, (boolean[])value);
            }
            case BYTE_ARR: {
                return (R)this.process(context, (byte[])value);
            }
            case SHORT_ARR: {
                return (R)this.process(context, (short[])value);
            }
            case CHAR_ARR: {
                return (R)this.process(context, (char[])value);
            }
            case INT_ARR: {
                return (R)this.process(context, (int[])value);
            }
            case LONG_ARR: {
                return (R)this.process(context, (long[])value);
            }
            case FLOAT_ARR: {
                return (R)this.process(context, (float[])value);
            }
            case DOUBLE_ARR: {
                return (R)this.process(context, (double[])value);
            }
            case LIST: {
                return (R)this.process(context, (List)value);
            }
            case SET: {
                return (R)this.process(context, (Set)value);
            }
            case MAP: {
                return (R)this.process(context, (Map)value);
            }
            case NONE: {
                return (R)this.processNone(context);
            }
            case DELETED: {
                return (R)this.processDeleted(context);
            }
        }
        throw Err.notExpected();
    }

    @Override
    public R dispatch(T context, Object value) {
        TypeKind kind = Cls.kindOf(value);
        return this.dispatch(context, kind, value);
    }

    @Override
    public R processUnknown(T context, Object value) {
        throw U.rte((String)("Unsupported type: " + Cls.of(value).getName()));
    }

    @Override
    public R process(T context, Boolean value) {
        return (R)this.process(context, value);
    }

    @Override
    public R process(T context, Byte value) {
        return (R)this.process(context, value);
    }

    @Override
    public R process(T context, Short value) {
        return (R)this.process(context, value);
    }

    @Override
    public R process(T context, Character value) {
        return (R)this.process(context, value.charValue());
    }

    @Override
    public R process(T context, Integer value) {
        return (R)this.process(context, value);
    }

    @Override
    public R process(T context, Long value) {
        return (R)this.process(context, value);
    }

    @Override
    public R process(T context, Float value) {
        return (R)this.process(context, value.floatValue());
    }

    @Override
    public R process(T context, Double value) {
        return (R)this.process(context, value);
    }
}

