/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.rapidoid.collection.AbstractCollectionDecorator;
import org.rapidoid.collection.ChangeTrackingIterator;

public class ChangeTrackingCollection<E>
extends AbstractCollectionDecorator<E> {
    protected final AtomicBoolean dirtyFlag;

    public ChangeTrackingCollection(Collection<E> decorated, AtomicBoolean dirtyFlag) {
        super(decorated);
        this.dirtyFlag = dirtyFlag;
    }

    @Override
    public boolean add(E e) {
        return this.changedIf(((Collection)this.decorated).add(e));
    }

    @Override
    public boolean remove(Object o) {
        return this.changedIf(((Collection)this.decorated).remove(o));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.changedIf(((Collection)this.decorated).addAll(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.changedIf(((Collection)this.decorated).retainAll(c));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.changedIf(((Collection)this.decorated).removeAll(c));
    }

    @Override
    public void clear() {
        if (!((Collection)this.decorated).isEmpty()) {
            ((Collection)this.decorated).clear();
            this.dirtyFlag.set(true);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new ChangeTrackingIterator(super.iterator(), this.dirtyFlag);
    }

    protected boolean changedIf(boolean changed) {
        if (changed) {
            this.dirtyFlag.set(true);
        }
        return changed;
    }
}

