/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.config;

import java.util.List;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Env;
import org.rapidoid.config.Config;
import org.rapidoid.config.ConfigUtil;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class ConfigLoaderUtil
extends RapidoidThing {
    public static void loadConfig(Config config, List<List<String>> detached, List<String> loaded) {
        String nameBase = config.getFilenameBase();
        if (U.notEmpty((String)nameBase)) {
            String configFilenamePattern = nameBase + ".yml_or_yaml";
            String configProfilePattern = nameBase + "-%s" + ".yml_or_yaml";
            ConfigUtil.load(Msc.path(config.getPath(), configFilenamePattern), config, false, loaded);
            for (String string : Env.profiles()) {
                ConfigUtil.load(Msc.path(config.getPath(), U.frmt((String)configProfilePattern, (Object[])new Object[]{string})), config, false, loaded);
            }
            for (List list : detached) {
                ConfigLoaderUtil.autoRefresh(list.isEmpty() ? config : config.sub(list));
            }
        }
    }

    static void loadBuiltInConfig(Config config, List<String> loaded) {
        String nameBase = config.getFilenameBase();
        if (U.notEmpty((String)nameBase)) {
            ConfigUtil.load("default-config.yml", config, true, loaded);
            for (String profile : Env.profiles()) {
                String filename = U.frmt((String)"default-config-%s.yml", (Object[])new Object[]{profile});
                ConfigUtil.load(filename, config, true, loaded);
            }
        }
    }

    static void loadDefaultConfig(Config config, List<String> loaded) {
        String nameBase = config.getFilenameBase();
        if (U.notEmpty((String)nameBase)) {
            String name = "default-" + nameBase;
            String filename = name + ".yml";
            filename = Msc.path(config.getPath(), filename);
            ConfigUtil.load(filename, config, true, loaded);
            for (String profile : Env.profiles()) {
                filename = U.frmt((String)(name + "-%s.yml"), (Object[])new Object[]{profile});
                filename = Msc.path(config.getPath(), filename);
                ConfigUtil.load(filename, config, true, loaded);
            }
        }
    }

    private static void autoRefresh(Config ... configs) {
        for (Config config : configs) {
            List<String> keys = config.keys();
            ConfigUtil.autoRefresh(config, ConfigLoaderUtil.filename(config, keys));
        }
    }

    private static String filename(Config config, List<String> keys) {
        U.must((keys.size() < 2 ? 1 : 0) != 0);
        String configName = keys.isEmpty() ? config.getFilenameBase() : keys.get(0);
        return Msc.path(config.getPath(), configName + ".yml_or_yaml");
    }
}

