/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.insight;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.collection.Coll;
import org.rapidoid.insight.Insightful;
import org.rapidoid.insight.InsightsThread;
import org.rapidoid.insight.Measure;
import org.rapidoid.insight.StatsMeasure;

public class Insights
extends RapidoidThing {
    private static final Map<String, List<Insightful>> RESOURCES = Coll.autoExpandingMap(ArrayList.class);
    private static final Map<String, List<Object>> INFOS = Coll.autoExpandingMap(ArrayList.class);
    private static final Map<String, List<Object>> RESETABLE_INFOS = Coll.autoExpandingMap(ArrayList.class);

    public static synchronized void register(Insightful resource) {
        RESOURCES.get(resource.getKind()).add(resource);
    }

    public static synchronized String getInfo() {
        String info = RESETABLE_INFOS.toString() + " :: " + INFOS.toString() + " :: " + RESOURCES.toString();
        for (List<Object> list : RESETABLE_INFOS.values()) {
            for (Object item : list) {
                if (!(item instanceof Measure)) continue;
                Measure m = (Measure)item;
                m.reset();
            }
        }
        return info;
    }

    public static String getCpuMemStats() {
        Runtime rt = Runtime.getRuntime();
        long totalMem = rt.totalMemory();
        long maxMem = rt.maxMemory();
        long freeMem = rt.freeMemory();
        long usedMem = totalMem - freeMem;
        int megs = 0x100000;
        String msg = "MEM [total=%s MB, used=%s MB, max=%s MB]";
        return String.format(msg, totalMem / (long)megs, usedMem / (long)megs, maxMem / (long)megs);
    }

    public static synchronized void show() {
        new InsightsThread().start();
    }

    public static synchronized void register(String name, Object info) {
        INFOS.get(name).add(info);
    }

    public static synchronized StatsMeasure stats(String name) {
        StatsMeasure measure = new StatsMeasure();
        RESETABLE_INFOS.get(name).add(measure);
        return measure;
    }

    public static synchronized void reset() {
        RESOURCES.clear();
        INFOS.clear();
        RESETABLE_INFOS.clear();
    }
}

