/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.sql;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.SQLException;
import org.rapidoid.RapidoidThing;
import org.rapidoid.config.Conf;
import org.rapidoid.sql.ConnectionPool;
import org.rapidoid.sql.JdbcClient;
import org.rapidoid.u.U;

public class C3P0ConnectionPool
extends RapidoidThing
implements ConnectionPool {
    private final ComboPooledDataSource pool = new ComboPooledDataSource();

    public C3P0ConnectionPool(String jdbcUrl, String driverClass, String username, String password) {
        this.init(jdbcUrl, driverClass, username, password);
    }

    public C3P0ConnectionPool(JdbcClient jdbc) {
        this(jdbc.url(), jdbc.driver(), jdbc.username(), jdbc.password());
        jdbc.pool(this);
    }

    private void init(String jdbcUrl, String driverClass, String username, String password) {
        try {
            this.pool.setDriverClass(driverClass);
        }
        catch (PropertyVetoException e) {
            throw U.rte((String)"Cannot load JDBC driver!", (Throwable)e);
        }
        this.pool.setJdbcUrl(jdbcUrl);
        this.pool.setUser(username);
        this.pool.setPassword(password);
        Conf.C3P0.applyTo(this.pool);
    }

    @Override
    public Connection getConnection(String jdbcUrl) throws SQLException {
        U.must((boolean)U.eq((Object)jdbcUrl, (Object)this.pool.getJdbcUrl()), (String)"The JDBC URLs don't match: '%s' and '%s'!", (Object)jdbcUrl, (Object)this.pool.getJdbcUrl());
        return this.pool.getConnection();
    }

    @Override
    public Connection getConnection(String jdbcUrl, String username, String password) throws SQLException {
        return this.pool.getConnection(username, password);
    }

    @Override
    public void releaseConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public ComboPooledDataSource pool() {
        return this.pool;
    }
}

