/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import java.util.Arrays;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Err;

public class SimpleList<T>
extends RapidoidThing {
    public T[] array;
    private int size = 0;
    private int position = 0;
    private final int growFactor;

    public SimpleList(int capacity) {
        this(capacity, 2);
    }

    public SimpleList(int capacity, int growFactor) {
        this.growFactor = growFactor;
        this.array = new Object[capacity];
    }

    public void clear() {
        this.size = 0;
        this.position = 0;
    }

    public int size() {
        return this.size;
    }

    public T get(int index) {
        return this.array[index];
    }

    public void add(T obj) {
        if (this.size == this.array.length) {
            this.array = Arrays.copyOf(this.array, this.array.length * this.growFactor);
        }
        this.array[this.size++] = obj;
    }

    public void addRotating(T obj) {
        if (this.size < this.array.length) {
            this.add(obj);
        } else {
            this.array[this.position++] = obj;
            if (this.position >= this.array.length) {
                this.position = 0;
            }
        }
    }

    public void delete(int index) {
        Err.bounds(index, 0, this.size - 1);
        System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        --this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.get(i));
        }
        return "[" + sb.toString() + "]";
    }
}

