/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.value;

import org.rapidoid.RapidoidThing;
import org.rapidoid.cls.Cls;
import org.rapidoid.commons.Err;
import org.rapidoid.u.U;
import org.rapidoid.value.OrValue;
import org.rapidoid.value.ToValue;
import org.rapidoid.value.Value;

public abstract class AbstractValue<T>
extends RapidoidThing
implements Value<T> {
    protected abstract T retrieve();

    protected void store(T value) {
        throw Err.notSupported();
    }

    @Override
    public T get() {
        T value = this.getOrNull();
        U.must((value != null ? 1 : 0) != 0, (String)"The value of %s is mandatory!", (Object)U.or((Object)this.desc(), (Object)"the variable"));
        return value;
    }

    @Override
    public T getOrNull() {
        return this.retrieve();
    }

    @Override
    public Value<T> orElse(Value<T> alternative) {
        U.notNull(alternative, (String)"alternative", (Object[])new Object[0]);
        return new OrValue<T>(this, alternative);
    }

    @Override
    public <K> K or(K alternative) {
        U.notNull(alternative, (String)"alternative", (Object[])new Object[0]);
        T value = this.getOrNull();
        return (K)(value != null ? Cls.convert(value, alternative.getClass()) : alternative);
    }

    @Override
    public <K> Value<K> to(Class<K> type) {
        U.notNull(type, (String)"type", (Object[])new Object[0]);
        return new ToValue<K>(this, type);
    }

    @Override
    public void set(T value) {
        this.store(value);
    }

    public String toString() {
        return U.str(this.getOrNull());
    }

    @Override
    public boolean exists() {
        return this.getOrNull() != null;
    }

    @Override
    public Value<String> str() {
        return this.to(String.class);
    }

    @Override
    public Value<Long> num() {
        return this.to(Long.TYPE);
    }

    @Override
    public Value<Boolean> bool() {
        return this.to(Boolean.TYPE);
    }

    @Override
    public String desc() {
        return null;
    }
}

