/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.config;

import java.util.List;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.RapidoidInfo;
import org.rapidoid.commons.Str;
import org.rapidoid.config.ConfigOption;
import org.rapidoid.config.ConfigOptions;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class ConfigHelp
extends RapidoidThing {
    public static void processHelp(Object[] args) {
        for (Object arg : args) {
            if (!arg.equals("--help")) continue;
            ConfigHelp.showUsage();
        }
    }

    private static void showUsage() {
        ConfigHelp.show(RapidoidInfo.nameAndInfo());
        ConfigHelp.show("");
        ConfigHelp.show("Usage:");
        if (Msc.dockerized()) {
            ConfigHelp.show("  docker run -it --rm -p <PORT>:8888 [-v <your-app-root>:/app] rapidoid/rapidoid[:tag] [option1 option2 ...]");
            ConfigHelp.show("  docker run -d -p <PORT>:8888 [-v <your-app-root>:/app] [-u nobody] rapidoid/rapidoid[:tag] [option1 option2 ...]");
        } else {
            ConfigHelp.show("  java -cp <yourapp>.jar com.example.Main [option1 option2 ...]");
        }
        ConfigHelp.show("\nExample:");
        if (Msc.dockerized()) {
            ConfigHelp.show("  docker run -it --rm -p 80:8888 -v $(pwd):/app -u nobody rapidoid/rapidoid app.services=welcome,ping admin.services=center users.admin.password=my-pass");
        } else {
            ConfigHelp.show("  java -cp <yourapp>.jar com.example.Main on.port=9090 on.address=127.0.0.1 app.services=ping,jmx admin.services=center production users.admin.password=my-pass");
        }
        ConfigHelp.show("\nMain configuration options:");
        ConfigHelp.showOpts(ConfigOptions.ALL);
        ConfigHelp.show("\nService activation options:");
        ConfigHelp.showOpts(ConfigOptions.SERVICES);
        ConfigHelp.show("\nFor a complete list of options see: http://www.rapidoid.org/the-default-configuration.html");
        System.exit(0);
    }

    private static void showOpts(List<ConfigOption> opts) {
        for (ConfigOption opt : opts) {
            String desc = U.frmt((String)"%s (default: %s)", (Object[])new Object[]{opt.getDesc(), opt.getDefaultValue()});
            ConfigHelp.opt(opt.getName(), desc);
        }
    }

    private static void opt(String opt, String desc) {
        ConfigHelp.show("  " + opt + Str.mul(" ", 25 - opt.length()) + " - " + desc);
    }

    private static void show(String msg) {
        System.out.println(msg);
    }
}

