/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.config;

import java.util.List;
import java.util.Set;
import org.rapidoid.RapidoidThing;
import org.rapidoid.config.ConfigOption;
import org.rapidoid.u.U;

public class ConfigOptions
extends RapidoidThing {
    public static final Set<String> SERVICE_NAMES = U.set();
    public static final List<ConfigOption> ALL = ConfigOptions.configOptions();
    public static final List<ConfigOption> SERVICES = ConfigOptions.serviceOptions();

    private static List<ConfigOption> configOptions() {
        List opts = U.list();
        opts.add(ConfigOptions.opt("config", "configuration filename prefix", "config"));
        opts.add(ConfigOptions.opt("dev", "run in DEV mode", "auto-detected"));
        opts.add(ConfigOptions.opt("production", "run in PRODUCTION mode", "auto-detected"));
        opts.add(ConfigOptions.opt("test", "run in TEST mode", "auto-detected"));
        opts.add(ConfigOptions.opt("secret=<SECRET>", "configure app-specific secret for encryption", "random"));
        opts.add(ConfigOptions.opt("profiles=<P1,P2...>", "comma-separated list of application profiles (e.g. mysql,prod)", "the 'default' profile"));
        opts.add(ConfigOptions.opt("on.port=<P>", "the default App server will listen at port P", 8888));
        opts.add(ConfigOptions.opt("on.address=<ADDR>", "the default App server will listen at address ADDR", "0.0.0.0"));
        opts.add(ConfigOptions.opt("admin.port=<P>", "the Admin server will listen at port P", "same as on.port"));
        opts.add(ConfigOptions.opt("admin.address=<ADDR>", "the Admin server will listen at address ADDR", "on.address"));
        opts.add(ConfigOptions.opt("app.services=<S1,S2...>", "comma-separated list of services to bootstrap on the App server", "none"));
        opts.add(ConfigOptions.opt("admin.services=<S1,S2...>", "comma-separated list of services to bootstrap on the Admin server", "none"));
        return opts;
    }

    private static List<ConfigOption> serviceOptions() {
        List opts = U.list();
        opts.add(ConfigOptions.srvOpt("center", "Admin Center"));
        opts.add(ConfigOptions.srvOpt("ping", "Ping service"));
        opts.add(ConfigOptions.srvOpt("status", "Status service"));
        opts.add(ConfigOptions.srvOpt("overview", "Overview service"));
        opts.add(ConfigOptions.srvOpt("application", "Application services"));
        opts.add(ConfigOptions.srvOpt("lifecycle", "Lifecycle services"));
        opts.add(ConfigOptions.srvOpt("jmx", "JMX services"));
        opts.add(ConfigOptions.srvOpt("metrics", "Metrics services"));
        opts.add(ConfigOptions.srvOpt("deploy", "Application deployment services"));
        opts.add(ConfigOptions.srvOpt("auth", "Authentication services"));
        opts.add(ConfigOptions.srvOpt("oauth", "OAuth services"));
        opts.add(ConfigOptions.srvOpt("entities", "JPA Entities services"));
        opts.add(ConfigOptions.srvOpt("welcome", "Welcome page"));
        return opts;
    }

    private static ConfigOption opt(String name, String desc, Object def) {
        return new ConfigOption(name, desc, def);
    }

    private static ConfigOption srvOpt(String name, String desc) {
        SERVICE_NAMES.add(name);
        return new ConfigOption(name, desc, "disabled");
    }
}

