/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.config;

import java.util.List;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Str;
import org.rapidoid.config.Conf;
import org.rapidoid.config.Config;
import org.rapidoid.config.ConfigParser;
import org.rapidoid.data.YAML;
import org.rapidoid.io.Res;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class ConfigUtil
extends RapidoidThing {
    public static final String YML_OR_YAML = ".yml_or_yaml";
    private static final ConfigParser YAML_PARSER = new ConfigParser(){

        @Override
        public Map<String, Object> parse(byte[] bytes) {
            return YAML.parse(bytes, Map.class);
        }
    };
    private static final Map<List<String>, Res> tracking = U.map();

    public static synchronized void autoRefresh(Config config, String yamlFilename) {
        ConfigUtil.autoRefresh(config, yamlFilename, YAML_PARSER);
    }

    public static synchronized void autoRefresh(final Config config, final String filename, final ConfigParser parser) {
        Log.info((String)"Initializing auto-refreshing config", (String)"filename", (Object)filename);
        final Res res = Res.from(filename, new String[0]);
        tracking.put(config.keys(), res);
        Runnable reload = new Runnable(){

            @Override
            public void run() {
                Map<String, Object> configData = null;
                byte[] bytes = res.getBytesOrNull();
                if (bytes != null) {
                    if (bytes.length > 0) {
                        configData = parser.parse(bytes);
                    }
                    Log.info((String)"Loading (refreshing) configuration file", (String)"filename", (Object)filename);
                    config.update(U.safe(configData));
                } else {
                    Log.trace((String)"Couldn't find configuration file", (String)"filename", (Object)filename);
                }
            }
        };
        reload.run();
        res.onChange("config", reload);
        res.trackChanges();
        res.exists();
    }

    public static synchronized List<List<String>> untrack() {
        List keys = U.list();
        for (Map.Entry<List<String>, Res> e : tracking.entrySet()) {
            keys.add(e.getKey());
            e.getValue().removeChangeListener("config");
        }
        tracking.clear();
        return keys;
    }

    static synchronized void load(String filename, Config config, List<String> loaded) {
        byte[] bytes = ConfigUtil.tryToLoad(filename, loaded);
        if (bytes != null) {
            if (bytes.length > 0) {
                Map configData = U.safe(YAML_PARSER.parse(bytes));
                Log.debug((String)"Loading configuration file", (String)"filename", (Object)filename);
                config.update(configData);
            }
        } else {
            Log.trace((String)"Couldn't find configuration file", (String)"filename", (Object)filename);
        }
    }

    private static byte[] tryToLoad(String filename, List<String> loaded) {
        Res res = ConfigUtil.findConfigResource(filename);
        if (res.exists()) {
            loaded.add(res.getCachedFileName());
        }
        return res.getBytesOrNull();
    }

    private static Res findConfigResource(String filename) {
        if (filename.endsWith(YML_OR_YAML)) {
            String basename = Str.trimr(filename, YML_OR_YAML);
            Res res = Res.from(basename + ".yaml", new String[0]);
            if (res.exists()) {
                return res;
            }
            return Res.from(basename + ".yml", new String[0]);
        }
        return Res.from(filename, new String[0]);
    }

    public static synchronized int cpus() {
        return Conf.ROOT.entry("cpus").or(Runtime.getRuntime().availableProcessors());
    }

    public static synchronized boolean micro() {
        return Conf.ROOT.is("micro");
    }
}

