/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.data;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.DeserializerCache;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import java.io.OutputStream;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.cls.Cls;
import org.rapidoid.commons.Env;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class JSON
extends RapidoidThing {
    public static final ObjectMapper MAPPER = JSON.newMapper();
    public static final ObjectMapper PRETTY_MAPPER = JSON.prettyMapper();

    public static ObjectMapper newMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setBase64Variant(Base64Variants.MODIFIED_FOR_URL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        if (!Env.dev()) {
            mapper.registerModule((Module)new AfterburnerModule());
        }
        return mapper;
    }

    private static ObjectMapper prettyMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setBase64Variant(Base64Variants.MODIFIED_FOR_URL);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        if (!Env.dev()) {
            mapper.registerModule((Module)new AfterburnerModule());
        }
        DefaultPrettyPrinter pp = new DefaultPrettyPrinter();
        pp = pp.withObjectIndenter((DefaultPrettyPrinter.Indenter)new DefaultIndenter("  ", "\n"));
        mapper.setDefaultPrettyPrinter((PrettyPrinter)pp);
        return mapper;
    }

    public static synchronized void reset() {
        for (ObjectMapper mapper : U.list((Object[])new ObjectMapper[]{MAPPER, PRETTY_MAPPER})) {
            SerializerProvider serializerProvider = mapper.getSerializerProvider();
            if (serializerProvider instanceof DefaultSerializerProvider) {
                DefaultSerializerProvider provider = (DefaultSerializerProvider)serializerProvider;
                provider.flushCachedSerializers();
            } else {
                Log.warn((String)"Couldn't clear the cache of Jackson serializers!", (String)"class", Cls.of(serializerProvider));
            }
            DeserializationContext deserializationContext = mapper.getDeserializationContext();
            Object cache = Cls.getFieldValue(deserializationContext, "_cache");
            if (cache instanceof DeserializerCache) {
                DeserializerCache deserializerCache = (DeserializerCache)cache;
                deserializerCache.flushCachedDeserializers();
                continue;
            }
            Log.warn((String)"Couldn't clear the cache of Jackson deserializers!", (String)"class", Cls.of(cache));
        }
    }

    public static String stringify(Object value) {
        try {
            return MAPPER.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] stringifyToBytes(Object value) {
        try {
            return MAPPER.writeValueAsBytes(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void stringify(Object value, OutputStream out) {
        try {
            MAPPER.writeValue(out, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String prettify(Object value) {
        try {
            return PRETTY_MAPPER.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void prettify(Object value, OutputStream out) {
        try {
            PRETTY_MAPPER.writeValue(out, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(byte[] json) {
        try {
            return (T)MAPPER.readValue(json, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(String json) {
        try {
            return (T)MAPPER.readValue(json, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(String json, Class<T> valueType) {
        try {
            return (T)MAPPER.readValue(json, valueType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(byte[] json, Class<T> valueType) {
        try {
            return (T)MAPPER.readValue(json, valueType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(String json, TypeReference<T> valueType) {
        try {
            return (T)MAPPER.readValue(json, valueType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(byte[] json, TypeReference<T> valueType) {
        try {
            return (T)MAPPER.readValue(json, valueType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> parseMap(String json) {
        return JSON.parse(json, Map.class);
    }

    public static void warmUp() {
        Msc.thread(new Runnable(){

            @Override
            public void run() {
                JSON.stringify(123);
                JSON.parse("{}", Map.class);
            }
        });
    }

    public static byte[] parseBytes(String json) {
        return JSON.parse(json, byte[].class);
    }
}

