/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.job;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.rapidoid.activity.RapidoidThreadFactory;
import org.rapidoid.concurrent.Callback;
import org.rapidoid.config.Conf;
import org.rapidoid.config.Config;
import org.rapidoid.config.RapidoidInitializer;
import org.rapidoid.ctx.Ctx;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.ctx.WithContext;
import org.rapidoid.job.CallbackExecutorJob;
import org.rapidoid.job.ContextPreservingJobWrapper;
import org.rapidoid.job.JobsDSL;
import org.rapidoid.job.PredefinedContextJobWrapper;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;
import org.rapidoid.util.Once;

public class Jobs
extends RapidoidInitializer {
    public static final Config JOBS = Conf.JOBS;
    private static final AtomicLong errorCounter = new AtomicLong();
    private static ScheduledExecutorService SCHEDULER;
    private static ExecutorService EXECUTOR;
    private static final Once init;

    private Jobs() {
    }

    public static synchronized ScheduledExecutorService scheduler() {
        if (SCHEDULER == null) {
            int threads = JOBS.sub("scheduler").entry("threads").or(64);
            SCHEDULER = Executors.newScheduledThreadPool(threads, new RapidoidThreadFactory("scheduler", true));
            if (init.go()) {
                Jobs.init();
            }
        }
        return SCHEDULER;
    }

    public static synchronized Executor executor() {
        if (EXECUTOR == null) {
            int threads = JOBS.sub("executor").entry("threads").or(64);
            EXECUTOR = Executors.newFixedThreadPool(threads, new RapidoidThreadFactory("executor", true));
            if (init.go()) {
                Jobs.init();
            }
        }
        return EXECUTOR;
    }

    private static void init() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Jobs.shutdownNow();
            }
        });
    }

    public static ScheduledFuture<?> schedule(Runnable job, long delay, TimeUnit unit) {
        return Jobs.scheduler().schedule(Jobs.wrap(job), delay, unit);
    }

    public static <T> ScheduledFuture<?> schedule(Callable<T> job, long delay, TimeUnit unit, Callback<T> callback) {
        return Jobs.schedule(Jobs.callbackJob(job, callback), delay, unit);
    }

    public static ScheduledFuture<?> scheduleAtFixedRate(Runnable job, long initialDelay, long period, TimeUnit unit) {
        return Jobs.scheduler().scheduleAtFixedRate(Jobs.wrap(job), initialDelay, period, unit);
    }

    public static <T> ScheduledFuture<?> scheduleAtFixedRate(Callable<T> job, long initialDelay, long period, TimeUnit unit, Callback<T> callback) {
        return Jobs.scheduleAtFixedRate(Jobs.callbackJob(job, callback), initialDelay, period, unit);
    }

    public static ScheduledFuture<?> scheduleWithFixedDelay(Runnable job, long initialDelay, long delay, TimeUnit unit) {
        return Jobs.scheduler().scheduleWithFixedDelay(Jobs.wrap(job), initialDelay, delay, unit);
    }

    public static <T> ScheduledFuture<?> scheduleWithFixedDelay(Callable<T> job, long initialDelay, long delay, TimeUnit unit, Callback<T> callback) {
        return Jobs.scheduleWithFixedDelay(Jobs.callbackJob(job, callback), initialDelay, delay, unit);
    }

    public static void execute(Runnable job) {
        ContextPreservingJobWrapper jobWrapper = Jobs.wrap(job);
        Jobs.executor().execute(jobWrapper);
    }

    public static void executeAndWait(Runnable job) {
        ContextPreservingJobWrapper jobWrapper = Jobs.wrap(job);
        Jobs.executor().execute(jobWrapper);
        while (!jobWrapper.isDone()) {
            U.sleep((long)10L);
        }
    }

    public static <T> void execute(Callable<T> job, Callback<T> callback) {
        Jobs.execute(Jobs.callbackJob(job, callback));
    }

    public static ContextPreservingJobWrapper wrap(Runnable job) {
        Ctx ctx = Ctxs.get();
        if (ctx != null) {
            ctx = ctx.span();
        }
        return new ContextPreservingJobWrapper(job, ctx);
    }

    public static <T> void call(Callback<T> callback, T result, Throwable error) {
        Jobs.execute(new CallbackExecutorJob<T>(callback, result, error));
    }

    private static <T> Runnable callbackJob(final Callable<T> job, final Callback<T> callback) {
        return new Runnable(){

            @Override
            public void run() {
                Object result;
                try {
                    result = job.call();
                }
                catch (Throwable e) {
                    Jobs.call(callback, null, e);
                    return;
                }
                Jobs.call(callback, result, null);
            }
        };
    }

    public static void executeInContext(WithContext context, Runnable action) {
        try {
            Jobs.executor().execute(new PredefinedContextJobWrapper(context, action));
        }
        catch (RejectedExecutionException e) {
            Log.warn((String)"The job was rejected by the executor/scheduler!", (String)"context", (Object)context.tag());
        }
    }

    public static JobsDSL after(long delay, TimeUnit unit) {
        return new JobsDSL(delay, -1L, unit);
    }

    public static JobsDSL every(long period, TimeUnit unit) {
        return new JobsDSL(-1L, period, unit);
    }

    public static AtomicLong errorCounter() {
        return errorCounter;
    }

    public static synchronized void shutdown() {
        if (EXECUTOR != null) {
            EXECUTOR.shutdown();
            EXECUTOR = null;
        }
        if (SCHEDULER != null) {
            SCHEDULER.shutdown();
            SCHEDULER = null;
        }
    }

    public static synchronized void shutdownNow() {
        if (EXECUTOR != null) {
            EXECUTOR.shutdownNow();
            EXECUTOR = null;
        }
        if (SCHEDULER != null) {
            SCHEDULER.shutdownNow();
            SCHEDULER = null;
        }
    }

    static {
        init = new Once();
    }
}

