/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.cache.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.rapidoid.cache.Cache;
import org.rapidoid.cache.impl.CacheStats;
import org.rapidoid.cache.impl.ConcurrentCacheAtom;
import org.rapidoid.cache.impl.ManageableCache;
import org.rapidoid.job.Jobs;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.u.U;
import org.rapidoid.util.AbstractMapImpl;
import org.rapidoid.util.MapEntry;
import org.rapidoid.util.SimpleList;

public class ConcurrentCache<K, V>
extends AbstractMapImpl<K, ConcurrentCacheAtom<V>>
implements Cache<K, V> {
    private static final int BUCKET_SIZE = 10;
    private final String name;
    private final int capacity;
    private final Mapper<K, V> loader;
    private final long ttlInMs;
    private final CacheStats stats = new CacheStats();

    public static <K, V> ConcurrentCache<K, V> create(String name, int capacity, Mapper<K, V> loader, long ttlInMs) {
        if (capacity > 20) {
            return new ConcurrentCache<K, V>(name, capacity / 10, 10, loader, ttlInMs);
        }
        return new ConcurrentCache<K, V>(name, 1, capacity, loader, ttlInMs);
    }

    public ConcurrentCache(String name, int buckets, int bucketSize, Mapper<K, V> loader, long ttlInMs) {
        super(buckets, bucketSize);
        this.name = name;
        this.loader = loader;
        this.ttlInMs = ttlInMs;
        U.must((buckets > 0 && bucketSize > 0 ? 1 : 0) != 0, (String)"The capacity is too small!");
        Jobs.every(1L, TimeUnit.SECONDS).run(new Runnable(){

            @Override
            public void run() {
                ConcurrentCache.this.crawl();
            }
        });
        this.capacity = buckets * bucketSize;
        new ManageableCache(this);
    }

    private void crawl() {
        SimpleList<T>[] buckets;
        for (SimpleList bucket : buckets = this.entries.buckets) {
            if (bucket == null) continue;
            for (int i = 0; i < bucket.size(); ++i) {
                ConcurrentCacheAtom cachedCalc;
                MapEntry entry = (MapEntry)((Object)bucket.get(i));
                if (entry == null || (cachedCalc = (ConcurrentCacheAtom)entry.value) == null) continue;
                cachedCalc.checkTTL();
            }
        }
    }

    @Override
    public V get(K key) {
        SimpleList<MapEntry<K, ConcurrentCacheAtom<V>>> bucket = this.entries.bucket(key.hashCode());
        MapEntry entry = this.findEntry(key, bucket);
        if (entry != null) {
            return ((ConcurrentCacheAtom)entry.value).get();
        }
        ConcurrentCacheAtom<V> atom = new ConcurrentCacheAtom<V>(this.loaderFor(key), this.ttlInMs, this.stats);
        this.putAtom(key, bucket, atom);
        return atom.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAtom(K key, SimpleList<MapEntry<K, ConcurrentCacheAtom<V>>> bucket, ConcurrentCacheAtom<V> atom) {
        SimpleList<MapEntry<K, ConcurrentCacheAtom<V>>> simpleList = bucket;
        synchronized (simpleList) {
            MapEntry<K, ConcurrentCacheAtom<V>> oldEntry = bucket.addRotating(new MapEntry<K, ConcurrentCacheAtom<V>>(key, atom));
            if (oldEntry != null) {
                ((ConcurrentCacheAtom)oldEntry.value).invalidate();
            }
        }
    }

    private Callable<V> loaderFor(final K key) {
        if (this.loader == null) {
            return null;
        }
        return new Callable<V>(){

            @Override
            public V call() throws Exception {
                return ConcurrentCache.this.loader.map(key);
            }
        };
    }

    @Override
    public V getIfExists(K key) {
        MapEntry entry = this.findEntry(key);
        return entry != null ? (V)((ConcurrentCacheAtom)entry.value).get() : null;
    }

    @Override
    public void invalidate(K key) {
        MapEntry entry = this.findEntry(key);
        if (entry != null) {
            ((ConcurrentCacheAtom)entry.value).invalidate();
        }
    }

    @Override
    public void set(K key, V value) {
        SimpleList<MapEntry<K, ConcurrentCacheAtom<V>>> bucket = this.entries.bucket(key.hashCode());
        MapEntry entry = this.findEntry(key, bucket);
        if (entry != null) {
            ((ConcurrentCacheAtom)entry.value).set(value);
        } else {
            ConcurrentCacheAtom<V> atom = new ConcurrentCacheAtom<V>(this.loaderFor(key), this.ttlInMs, this.stats);
            atom.set(value);
            this.putAtom(key, bucket, atom);
        }
    }

    public long ttlInMs() {
        return this.ttlInMs;
    }

    public CacheStats stats() {
        return this.stats;
    }

    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int size = 0;
        for (int i = 0; i < this.entries.bucketCount(); ++i) {
            SimpleList bucket;
            SimpleList simpleList = bucket = this.entries.bucket(i);
            synchronized (simpleList) {
                size += bucket.size();
                continue;
            }
        }
        return size;
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public void bypass() {
        this.stats.bypassed.incrementAndGet();
    }
}

