/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.cache.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.rapidoid.RapidoidThing;
import org.rapidoid.cache.CacheAtom;
import org.rapidoid.cache.impl.CacheStats;
import org.rapidoid.u.U;
import org.rapidoid.util.Resetable;

public class ConcurrentCacheAtom<V>
extends RapidoidThing
implements CacheAtom<V>,
Callable<V> {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Callable<V> loader;
    private final long ttlInMs;
    private final AtomicLong hits = new AtomicLong();
    private final AtomicLong misses = new AtomicLong();
    private final AtomicLong errors = new AtomicLong();
    private volatile V value;
    private volatile boolean cacheValid = false;
    private volatile long expiresAt;
    private final CacheStats stats;

    public ConcurrentCacheAtom(Callable<V> loader, long ttlInMs, CacheStats stats) {
        this.loader = loader;
        this.ttlInMs = ttlInMs;
        this.stats = stats;
    }

    @Override
    public V get() {
        return this.retrieveCachedValue(true, true);
    }

    @Override
    public V getIfExists() {
        return this.retrieveCachedValue(false, true);
    }

    private V retrieveCachedValue(boolean loadIfExpired, boolean updateStats) {
        Object oldValue = null;
        Throwable error = null;
        boolean missed = false;
        long now = U.time();
        this.lock.readLock().lock();
        if (!this.cacheValid || now > this.expiresAt) {
            this.lock.readLock().unlock();
            this.lock.writeLock().lock();
            if (!this.cacheValid || now > this.expiresAt) {
                Object newValue;
                if (loadIfExpired) {
                    try {
                        newValue = this.loader != null ? this.loader.call() : null;
                    }
                    catch (Throwable e) {
                        error = e;
                        newValue = null;
                    }
                } else {
                    newValue = null;
                }
                oldValue = this.setValueInsideWriteLock(newValue);
                missed = true;
            }
            this.lock.readLock().lock();
            this.lock.writeLock().unlock();
        }
        V result = this.value;
        this.lock.readLock().unlock();
        this.releaseOldValue(oldValue);
        if (updateStats) {
            this.updateStats(missed, error != null);
        }
        if (error != null) {
            throw U.rte((String)"Couldn't recalculate the cache value!", (Throwable)error);
        }
        return result;
    }

    private void updateStats(boolean missed, boolean hasError) {
        if (hasError) {
            this.errors.incrementAndGet();
            this.stats.errors.incrementAndGet();
        } else if (missed) {
            this.misses.incrementAndGet();
            this.stats.misses.incrementAndGet();
        } else {
            this.hits.incrementAndGet();
            this.stats.hits.incrementAndGet();
        }
    }

    @Override
    public void set(V value) {
        this.lock.writeLock().lock();
        V oldValue = this.setValueInsideWriteLock(value);
        this.lock.writeLock().unlock();
        this.releaseOldValue(oldValue);
    }

    private V setValueInsideWriteLock(V newValue) {
        V oldValue = this.value;
        boolean isRealValue = newValue != null;
        this.value = newValue;
        this.cacheValid = isRealValue;
        this.expiresAt = isRealValue ? (this.ttlInMs > 0L ? U.time() + this.ttlInMs : Long.MAX_VALUE) : 0L;
        return oldValue;
    }

    @Override
    public void invalidate() {
        this.lock.writeLock().lock();
        V oldValue = this.setValueInsideWriteLock(null);
        this.lock.writeLock().unlock();
        this.releaseOldValue(oldValue);
    }

    private void releaseOldValue(V oldValue) {
        if (oldValue instanceof Resetable) {
            ((Resetable)oldValue).reset();
        }
    }

    void checkTTL() {
        this.retrieveCachedValue(false, false);
    }

    @Override
    public V call() throws Exception {
        return this.get();
    }

    public AtomicLong getHits() {
        return this.hits;
    }

    public AtomicLong getMisses() {
        return this.misses;
    }

    public AtomicLong getErrors() {
        return this.errors;
    }

    public String toString() {
        return "ConcurrentCached [ttlInMs=" + this.ttlInMs + ", hits=" + this.hits + ", misses=" + this.misses + ", errors=" + this.errors + ", value=" + this.value + ", cacheValid=" + this.cacheValid + ", expiresAt=" + this.expiresAt + "]";
    }
}

