/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.config;

import java.util.List;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Str;
import org.rapidoid.config.Conf;
import org.rapidoid.config.Config;
import org.rapidoid.config.ConfigParser;
import org.rapidoid.data.Parse;
import org.rapidoid.io.Res;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class ConfigUtil
extends RapidoidThing {
    public static final String YML_OR_YAML_OR_JSON = ".yml_or_yaml_or_json";
    private static final ConfigParser YAML_OR_JSON_PARSER = new ConfigParser(){

        @Override
        public Map<String, Object> parse(byte[] bytes) {
            return Parse.data(bytes, Map.class);
        }
    };

    static synchronized void load(String filename, Config config, List<String> loaded) {
        byte[] bytes = ConfigUtil.tryToLoad(filename, loaded);
        if (bytes != null) {
            if (bytes.length > 0) {
                Map configData = U.safe(YAML_OR_JSON_PARSER.parse(bytes));
                Log.debug((String)"Loading configuration file", (String)"filename", (Object)filename);
                config.update(configData);
            }
        } else {
            Log.trace((String)"Couldn't find configuration file", (String)"filename", (Object)filename);
        }
    }

    private static byte[] tryToLoad(String filename, List<String> loaded) {
        Res res = ConfigUtil.findConfigResource(filename);
        if (res.exists()) {
            loaded.add(res.getCachedFileName());
        }
        return res.getBytesOrNull();
    }

    private static Res findConfigResource(String filename) {
        if (filename.endsWith(YML_OR_YAML_OR_JSON)) {
            String basename = Str.trimr(filename, YML_OR_YAML_OR_JSON);
            Res res = Res.from(basename + ".yaml", new String[0]);
            if (res.exists()) {
                return res;
            }
            res = Res.from(basename + ".yml", new String[0]);
            if (res.exists()) {
                return res;
            }
            return Res.from(basename + ".json", new String[0]);
        }
        return Res.from(filename, new String[0]);
    }

    public static synchronized int cpus() {
        return Conf.ROOT.entry("cpus").or(Runtime.getRuntime().availableProcessors());
    }

    public static synchronized boolean micro() {
        return Conf.ROOT.is("micro");
    }
}

