/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.ctx;

import org.rapidoid.RapidoidThing;
import org.rapidoid.collection.Coll;
import org.rapidoid.ctx.Ctx;
import org.rapidoid.ctx.PersisterProvider;
import org.rapidoid.ctx.UserInfo;
import org.rapidoid.ctx.WithContext;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class Ctxs
extends RapidoidThing {
    private static volatile ThreadLocal<Ctx> CTXS = new ThreadLocal();
    private static volatile PersisterProvider persisterProvider;

    private Ctxs() {
    }

    public static Ctx get() {
        return CTXS.get();
    }

    public static Ctx required() {
        Ctx ctx = Ctxs.get();
        if (ctx == null) {
            throw new IllegalStateException("No context is available!");
        }
        return ctx;
    }

    public static boolean hasContext() {
        return Ctxs.get() != null;
    }

    public static void attach(Ctx ctx) {
        if (!Ctxs.hasContext()) {
            if (ctx != null) {
                CTXS.set(ctx);
            }
        } else {
            throw new IllegalStateException("The context was already opened: " + Ctxs.required());
        }
    }

    public static Ctx open(WithContext context) {
        Ctx ctx = Ctxs.open(context.tag());
        ctx.setExchange(context.exchange());
        ctx.setPersister(context.persister());
        ctx.setUser(new UserInfo(context.username(), context.roles(), context.scope()));
        Coll.assign(ctx.extras(), U.safe(context.extras()));
        return ctx;
    }

    public static Ctx open(String tag) {
        Ctx ctx = new Ctx(tag);
        Log.debug((String)"Opening context", (String)"ctx", (Object)ctx);
        Ctxs.attach(ctx);
        return ctx;
    }

    public static void close() {
        block4: {
            try {
                Ctx ctx = Ctxs.get();
                if (ctx != null) {
                    ctx.close();
                    break block4;
                }
                throw new RuntimeException("There is no opened context!");
            }
            finally {
                CTXS.remove();
            }
        }
    }

    public static PersisterProvider getPersisterProvider() {
        return persisterProvider;
    }

    public static void setPersisterProvider(PersisterProvider persisterProvider) {
        Ctxs.persisterProvider = persisterProvider;
    }

    public static Object createPersister(Ctx ctx) {
        U.notNull((Object)persisterProvider, (String)"Ctxs.persisterProvider", (Object[])new Object[0]);
        return persisterProvider.openPersister(ctx);
    }

    public static void closePersister(Ctx ctx, Object persister) {
        U.notNull((Object)persisterProvider, (String)"Ctxs.persisterProvider", (Object[])new Object[0]);
        persisterProvider.closePersister(ctx, persister);
    }

    public static void reset() {
        CTXS = new ThreadLocal();
    }
}

