/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.deploy;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.rapidoid.RapidoidThing;
import org.rapidoid.io.IO;
import org.rapidoid.log.Log;
import org.rapidoid.process.Proc;
import org.rapidoid.process.ProcessHandle;
import org.rapidoid.process.Processes;
import org.rapidoid.scan.ClasspathUtil;
import org.rapidoid.u.U;

public class AppDeployer
extends RapidoidThing {
    private static final Processes DEPLOYED = new Processes("deployed");
    private static final String CLASSPATH = System.getProperty("java.class.path");

    public static String appJar() {
        return ClasspathUtil.appJar();
    }

    private static void runIfExists(String appId, String appJar) {
        if (!IO.find().in("/app").getNames().isEmpty()) {
            Log.info((String)"Deploying pre-existing application", (String)"id", (Object)appId);
            AppDeployer.runAppJar(appId);
        }
    }

    private static void runAppJar(String appId) {
        String appJar = AppDeployer.appJar();
        String[] appJarCmd = new String[]{"java", "-jar", appJar, "root=/app"};
        String[] defaultAppCmd = new String[]{"java", "-cp", CLASSPATH, "org.rapidoid.platform.DefaultApp", "root=/app"};
        String[] cmd = new File(appJar).exists() ? appJarCmd : defaultAppCmd;
        Proc.group(DEPLOYED).id(appId).printingOutput(true).linePrefix("[APP] ").run(cmd);
    }

    public static void deploy(String stagedAppJar, String appJar) {
        U.must((boolean)U.notEmpty((String)stagedAppJar), (String)"Empty application jar name was provided!");
        Log.info((String)"Deploying staged JAR...", (String)"filename", (Object)stagedAppJar);
        U.must((boolean)new File(stagedAppJar).exists(), (String)"Cannot deploy, the application needs to be staged first, cannot find: %s", (Object)stagedAppJar);
        try {
            Files.move(Paths.get(stagedAppJar, new String[0]), Paths.get(appJar, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw U.rte((String)"Deployment error!", (Throwable)e);
        }
        AppDeployer.startOrRestartApp("app");
        Log.info((String)"Deployed JAR", (String)"filename", (Object)appJar);
    }

    public static void startOrRestartApp(String appId) {
        ProcessHandle proc = (ProcessHandle)DEPLOYED.find(appId);
        if (proc != null) {
            Log.info((String)"Restarting the previously deployed application", (String)"id", (Object)proc.id(), (String)"process", (Object)proc.params().command());
            proc.restart();
        } else {
            Log.info((String)"Starting the deployed application");
            AppDeployer.runAppJar(appId);
        }
    }

    public static void stageJar(String appJar, byte[] content) {
        String stagedAppJar = appJar + ".staged";
        U.must((boolean)U.notEmpty((String)appJar), (String)"Empty application jar name was provided!");
        IO.save(stagedAppJar, content);
        Log.info((String)"Staged application jar", (String)"size", (Object)content.length, (String)"destination", (Object)appJar);
    }

    public static Processes processes() {
        return DEPLOYED;
    }

    public static void bootstrap() {
        String appJar = AppDeployer.appJar();
        if (U.notEmpty((String)appJar)) {
            AppDeployer.runIfExists("app", appJar);
        }
    }

    public static void stopApp(String appId) {
        ProcessHandle proc = (ProcessHandle)DEPLOYED.find(appId);
        if (proc != null) {
            Log.info((String)"Stopping application", (String)"id", (Object)proc.id(), (String)"process", (Object)proc.params().command());
            proc.destroy();
        }
    }
}

