/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.env;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rapidoid.RapidoidThing;
import org.rapidoid.config.Conf;
import org.rapidoid.env.EnvMode;
import org.rapidoid.env.EnvProperties;
import org.rapidoid.env.Environment;
import org.rapidoid.env.RapidoidEnv;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class Env
extends RapidoidThing {
    private static final Environment env = new Environment();
    private static volatile String root;

    public static void reset() {
        env.reset();
        root = null;
        RapidoidEnv.reset();
    }

    public static boolean production() {
        return Env.mode() == EnvMode.PRODUCTION;
    }

    public static boolean test() {
        return Env.mode() == EnvMode.TEST;
    }

    public static boolean dev() {
        return Env.mode() == EnvMode.DEV;
    }

    public static boolean isInitialized() {
        return env.isInitialized();
    }

    public static EnvMode mode() {
        return env.mode();
    }

    public static Set<String> profiles() {
        return env.profiles();
    }

    public static void setProfiles(String ... profiles) {
        env.setProfiles(profiles);
    }

    public static void setArgs(String ... args) {
        env.setArgs(args);
        Env.processInitialConfig();
    }

    private static void processInitialConfig() {
        String config = Env.initial("config");
        String root = Env.initial("root");
        if (Msc.dockerized() && U.isEmpty((String)root)) {
            root = "/app";
        }
        if (root != null) {
            Env.setRoot(root);
        }
        if (config != null) {
            Conf.setFilenameBase(config);
        }
    }

    static String initial(String key) {
        Map<String, Object> envAndArgs = Env.argsAsMap();
        return (String)U.or((Object)envAndArgs.get(key), (Object)Env.properties().get(key));
    }

    static boolean hasInitial(String key, Object value) {
        return String.valueOf(Env.initial(key)).equalsIgnoreCase(String.valueOf(value));
    }

    public static List<String> args() {
        return env.args();
    }

    public static boolean hasProfile(String profileName) {
        return env.hasProfile(profileName);
    }

    public static boolean hasAnyProfile(String ... profileNames) {
        return env.hasAnyProfile(profileNames);
    }

    public static EnvProperties properties() {
        return env.properties();
    }

    public static Map<String, Object> argsAsMap() {
        return env.argsAsMap();
    }

    public static void setRoot(String root) {
        if (U.neq((Object)Env.root, (Object)root)) {
            File dir = new File(root);
            if (dir.exists()) {
                if (dir.isDirectory()) {
                    Object[] files = dir.listFiles();
                    if (files != null) {
                        Log.info((String)"Setting application root", (String)"!root", (Object)root, (String)"!content", (Object)U.list((Object[])files));
                    } else {
                        Log.error((String)"Couldn't access the application root!", (String)"!root", (Object)root);
                    }
                } else {
                    Log.error((String)"The configured application root must be a folder!", (String)"!root", (Object)root);
                }
            } else {
                Log.error((String)"The configured application root folder doesn't exist!", (String)"!root", (Object)root);
            }
            Env.root = root;
        }
    }

    public static String root() {
        return root;
    }
}

