/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.io;

import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Str;
import org.rapidoid.io.FileSearchResult;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class FileSearch
extends RapidoidThing {
    private volatile String[] name;
    private volatile String[] ignore;
    private volatile String regex;
    private volatile String ignoreRegex;
    private volatile String location;
    private volatile boolean files;
    private volatile boolean folders;
    private volatile boolean recursive;

    public FileSearch name(String ... name) {
        this.name = name;
        return this;
    }

    public FileSearch ignore(String ... ignore) {
        this.ignore = ignore;
        return this;
    }

    public FileSearch in(String location) {
        this.location = location;
        return this;
    }

    public FileSearch regex(String regex) {
        this.regex = regex;
        return this;
    }

    public FileSearch ignoreRegex(String ignoreRegex) {
        this.ignoreRegex = ignoreRegex;
        return this;
    }

    public FileSearch files() {
        this.files = true;
        return this;
    }

    public FileSearch folders() {
        this.folders = true;
        return this;
    }

    public FileSearch recursive() {
        this.recursive = true;
        return this;
    }

    public List<String> getNames() {
        List names = U.list();
        for (File file : this.get()) {
            names.add(file.getAbsolutePath());
        }
        return names;
    }

    public List<String> getLocations() {
        List names = U.list();
        for (File file : this.get()) {
            names.add(file.getParent());
        }
        return names;
    }

    public List<String> getRelativeNames() {
        List names = U.list();
        for (FileSearchResult result : this.getResults()) {
            names.add(result.relativeName());
        }
        return names;
    }

    public List<FileSearchResult> getResults() {
        List results = U.list();
        for (File file : this.get()) {
            String filename = file.getAbsolutePath();
            U.must((boolean)filename.startsWith(this.location));
            String relativeName = Str.triml(filename, this.location);
            relativeName = Str.triml(relativeName, File.separator);
            results.add(new FileSearchResult(file, filename, relativeName));
        }
        return results;
    }

    public List<File> get() {
        List found = U.list();
        boolean filesAndFolders = this.files == this.folders;
        U.must((boolean)U.notEmpty((String)this.location), (String)"Location must be specified!");
        U.must((U.isEmpty((Object[])this.name) || U.isEmpty((String)this.regex) ? 1 : 0) != 0, (String)"You can specify either 'name' or 'regex', not both of them!");
        U.must((U.isEmpty((Object[])this.ignore) || U.isEmpty((String)this.ignoreRegex) ? 1 : 0) != 0, (String)"You can specify either 'ignore' or 'ignoreRegex', not both of them!");
        String matching = U.notEmpty((Object[])this.name) ? Str.wildcardsToRegex(this.name) : this.regex;
        String ignoring = U.notEmpty((Object[])this.ignore) ? Str.wildcardsToRegex(this.ignore) : this.ignoreRegex;
        Pattern mtch = U.notEmpty((String)matching) ? Pattern.compile(matching) : null;
        Pattern ignr = U.notEmpty((String)ignoring) ? Pattern.compile(ignoring) : null;
        FileSearch.search(new File(this.location), found, mtch, ignr, this.files || filesAndFolders, this.folders || filesAndFolders, this.recursive);
        return found;
    }

    static void search(File dir, List<File> found, Pattern matching, Pattern ignoring, boolean includeFiles, boolean includeDirectories, boolean recursive) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (includeFiles && f.isFile() || includeDirectories && f.isDirectory()) {
                    String filename = f.getName();
                    Log.debug((String)"Matching file/folder against the search criteria", (String)"name", (Object)f.getAbsoluteFile());
                    if (!(matching != null && !matching.matcher(filename).matches() || ignoring != null && ignoring.matcher(filename).matches())) {
                        Log.debug((String)"The file/folder matches", (String)"name", (Object)f.getAbsoluteFile());
                        found.add(f);
                    }
                }
                if (!recursive || !f.isDirectory()) continue;
                FileSearch.search(f, found, matching, ignoring, includeFiles, includeDirectories, recursive);
            }
        }
    }
}

