/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.io;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.rapidoid.RapidoidThing;
import org.rapidoid.collection.Coll;
import org.rapidoid.env.Env;
import org.rapidoid.io.IO;
import org.rapidoid.io.ResKey;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class Res
extends RapidoidThing {
    public static volatile Pattern REGEX_INVALID_FILENAME = Pattern.compile("(?:[*?'\"<>|\\x00-\\x1F]|\\.\\.)");
    private static final ConcurrentMap<ResKey, Res> FILES = Coll.concurrentMap();
    public static final ScheduledThreadPoolExecutor EXECUTOR = new ScheduledThreadPoolExecutor(1);
    private static final String[] DEFAULT_LOCATIONS = new String[]{""};
    private final String name;
    private final String[] possibleLocations;
    private volatile byte[] bytes;
    private volatile long lastUpdatedOn;
    private volatile long lastModified;
    private volatile String content;
    private volatile boolean trackingChanges;
    private volatile String cachedFileName;
    private volatile Object attachment;
    private volatile boolean hidden;
    private final Map<String, Runnable> changeListeners = Coll.synchronizedMap();

    private Res(String name, String ... possibleLocations) {
        this.name = name;
        this.possibleLocations = possibleLocations;
        Res.validateFilename(name);
    }

    private static void validateFilename(String filename) {
        U.must((!REGEX_INVALID_FILENAME.matcher(filename).find() ? 1 : 0) != 0, (String)"Invalid resource name: %s", (Object)filename);
    }

    public static Res from(File file, String ... possibleLocations) {
        U.must((!file.isAbsolute() || U.isEmpty((Object[])possibleLocations) ? 1 : 0) != 0, (String)"Cannot specify locations for an absolute filename!");
        return file.isAbsolute() ? Res.absolute(file) : Res.relative(file.getPath(), possibleLocations);
    }

    public static Res from(String filename, String ... possibleLocations) {
        return Res.from(new File(filename), possibleLocations);
    }

    private static Res absolute(File file) {
        return Res.create(file.getAbsolutePath(), new String[0]);
    }

    private static Res relative(String filename, String ... possibleLocations) {
        File file = new File(filename);
        if (file.isAbsolute()) {
            return Res.absolute(file);
        }
        if (U.isEmpty((Object[])possibleLocations)) {
            possibleLocations = DEFAULT_LOCATIONS;
        }
        U.must((!U.isEmpty((String)filename) ? 1 : 0) != 0, (String)"Resource filename must be specified!");
        U.must((!file.isAbsolute() ? 1 : 0) != 0, (String)"Expected relative filename!");
        String root = Env.root();
        if (U.notEmpty((String)Env.root())) {
            String[] loc = new String[possibleLocations.length * 2];
            for (int i = 0; i < possibleLocations.length; ++i) {
                loc[2 * i] = Msc.path(root, possibleLocations[i]);
                loc[2 * i + 1] = possibleLocations[i];
            }
            possibleLocations = loc;
        }
        return Res.create(filename, possibleLocations);
    }

    private static Res create(String filename, String ... possibleLocations) {
        for (int i = 0; i < possibleLocations.length; ++i) {
            possibleLocations[i] = Msc.refinePath(possibleLocations[i]);
        }
        ResKey key = new ResKey(filename, possibleLocations);
        Res cachedFile = (Res)((Object)FILES.get((Object)key));
        if (cachedFile == null) {
            cachedFile = new Res(filename, possibleLocations);
            if (FILES.size() < 1000) {
                FILES.putIfAbsent(key, cachedFile);
            }
        }
        return cachedFile;
    }

    public synchronized byte[] getBytes() {
        this.loadResource();
        this.mustExist();
        return this.bytes;
    }

    public byte[] getBytesOrNull() {
        this.loadResource();
        return this.bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadResource() {
        block7: {
            boolean hasChanged;
            if (U.time() - this.lastUpdatedOn < 500L) break block7;
            Res res = this;
            synchronized (res) {
                byte[] foundRes;
                byte[] old;
                block9: {
                    block8: {
                        old = this.bytes;
                        foundRes = null;
                        if (this.possibleLocations.length != 0) break block8;
                        Log.trace((String)"Trying to load the resource", (String)"name", (Object)this.name);
                        byte[] res2 = this.load(this.name);
                        if (res2 == null) break block9;
                        Log.debug((String)"Loaded the resource", (String)"name", (Object)this.name);
                        foundRes = res2;
                        this.cachedFileName = this.name;
                        break block9;
                    }
                    for (String location : this.possibleLocations) {
                        String filename = Msc.path(location, this.name);
                        Log.trace((String)"Trying to load the resource", (String)"name", (Object)this.name, (String)"location", (Object)location, (String)"filename", (Object)filename);
                        byte[] res3 = this.load(filename);
                        if (res3 == null) continue;
                        Log.debug((String)"Loaded the resource", (String)"name", (Object)this.name, (String)"file", (Object)filename);
                        foundRes = res3;
                        this.cachedFileName = filename;
                        break;
                    }
                }
                if (foundRes == null) {
                    this.cachedFileName = null;
                }
                this.bytes = foundRes;
                hasChanged = !U.eq((Object)old, (Object)this.bytes) && (old == null || this.bytes == null || !Arrays.equals(old, this.bytes));
                this.lastUpdatedOn = U.time();
                if (hasChanged) {
                    this.content = null;
                    this.attachment = null;
                }
            }
            if (hasChanged) {
                this.notifyChangeListeners();
            }
        }
    }

    protected byte[] load(String filename) {
        File file = IO.file(filename);
        if (file.exists()) {
            long lastModif;
            if (!file.isFile() || file.isDirectory()) {
                return null;
            }
            Log.trace((String)"Resource file exists", (String)"name", (Object)this.name, (String)"file", (Object)file);
            try {
                lastModif = Files.getLastModifiedTime(file.toPath(), new LinkOption[0]).to(TimeUnit.MILLISECONDS);
            }
            catch (IOException e) {
                lastModif = U.time();
            }
            if (lastModif > this.lastModified || !filename.equals(this.cachedFileName)) {
                Log.debug((String)"Loading resource file", (String)"name", (Object)this.name, (String)"file", (Object)file);
                this.lastModified = file.lastModified();
                this.hidden = file.isHidden();
                return IO.loadBytes(filename);
            }
            Log.trace((String)"Resource file not modified", (String)"name", (Object)this.name, (String)"file", (Object)file);
            return this.bytes;
        }
        Log.trace((String)"Trying to load classpath resource", (String)"name", (Object)this.name, (String)"file", (Object)file);
        this.hidden = false;
        return IO.loadBytes(filename);
    }

    public synchronized String getContent() {
        this.mustExist();
        if (this.content == null) {
            byte[] b = this.getBytes();
            this.content = b != null ? new String(b) : null;
        }
        return this.content;
    }

    public boolean exists() {
        this.loadResource();
        return this.bytes != null;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Res(" + this.name + ")";
    }

    public synchronized Reader getReader() {
        this.mustExist();
        return new StringReader(this.getContent());
    }

    public Res mustExist() {
        U.must((boolean)this.exists(), (String)"The file '%s' doesn't exist! Path: %s", (Object)this.name, (Object)this.possibleLocations);
        return this;
    }

    public Res onChange(String name, Runnable listener) {
        this.changeListeners.put(name, listener);
        return this;
    }

    public Res removeChangeListener(String name) {
        this.changeListeners.remove(name);
        return this;
    }

    private void notifyChangeListeners() {
        if (!this.changeListeners.isEmpty()) {
            Log.info((String)"Resource has changed, reloading...", (String)"name", (Object)this.name);
        }
        for (Runnable listener : this.changeListeners.values()) {
            try {
                listener.run();
            }
            catch (Throwable e) {
                Log.error((String)"Error while processing resource changes!", (Throwable)e);
            }
        }
    }

    public synchronized Res trackChanges() {
        if (!this.trackingChanges) {
            this.trackingChanges = true;
            EXECUTOR.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    Res.this.loadResource();
                }
            }, 0L, 300L, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    public <T> T attachment() {
        return (T)(this.exists() ? this.attachment : null);
    }

    public void attach(Object attachment) {
        this.attachment = attachment;
    }

    public String getCachedFileName() {
        return this.cachedFileName;
    }

    public static synchronized void reset() {
        for (Res res : FILES.values()) {
            res.invalidate();
        }
        FILES.clear();
    }

    public void invalidate() {
        this.lastUpdatedOn = 0L;
    }

    public boolean isHidden() {
        return this.hidden;
    }
}

