/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.pool;

import java.util.concurrent.Callable;
import org.rapidoid.insight.AbstractInsightful;
import org.rapidoid.log.Log;
import org.rapidoid.pool.Pool;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class ArrayPool<T>
extends AbstractInsightful
implements Pool<T> {
    private final Callable<T> factory;
    private T[] free;
    private int freeN = 0;
    private int instancesN = 0;

    public ArrayPool(String name, Callable<T> factory, int capacity) {
        super("pool", name);
        this.factory = factory;
        this.free = new Object[capacity];
    }

    @Override
    public T get() {
        if (this.freeN == 0) {
            try {
                ++this.instancesN;
                return this.factory.call();
            }
            catch (Exception e) {
                throw U.rte((Throwable)e);
            }
        }
        T obj = this.free[--this.freeN];
        assert (obj != null);
        return obj;
    }

    @Override
    public void release(T obj) {
        assert (obj != null);
        if (this.freeN >= this.free.length) {
            int expandFactor = this.free.length < 1000000 ? 10 : 2;
            int newSize = this.free.length * expandFactor;
            Log.info((String)"The pool wasn't big enough, expanding...", (String)"name", (Object)this.getName(), (String)"old size", (Object)this.free.length, (String)"new size", (Object)newSize);
            this.free = Msc.expand(this.free, expandFactor);
        }
        this.free[this.freeN++] = obj;
    }

    @Override
    public int objectsCreated() {
        return this.instancesN;
    }

    @Override
    public int size() {
        return this.freeN;
    }

    public String toString() {
        return this.getName() + "#" + this.size();
    }

    @Override
    public void clear() {
        this.freeN = 0;
        this.instancesN = 0;
        this.free = new Object[100];
    }
}

