/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import org.rapidoid.RapidoidThing;
import org.rapidoid.u.U;
import org.rapidoid.util.MapEntry;
import org.rapidoid.util.SimpleHashTable;
import org.rapidoid.util.SimpleList;
import org.rapidoid.util.SimpleMap;

public abstract class AbstractMapImpl<K, V>
extends RapidoidThing
implements SimpleMap<K, V> {
    protected final SimpleHashTable<MapEntry<K, V>> entries;
    protected V defaultValue;

    public AbstractMapImpl(int width) {
        this.entries = new SimpleHashTable(width);
    }

    public AbstractMapImpl(int width, int initialBucketSize) {
        this.entries = new SimpleHashTable(width, initialBucketSize);
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public void setDefaultValue(V defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public V getDefaultValue() {
        return this.defaultValue;
    }

    protected MapEntry<K, V> findEntry(K key) {
        SimpleList<MapEntry<K, V>> bucket = this.entries.bucket(key.hashCode());
        return this.findEntry(key, bucket);
    }

    protected MapEntry<K, V> findEntry(K key, SimpleList<MapEntry<K, V>> bucket) {
        for (int i = 0; i < bucket.size(); ++i) {
            MapEntry<K, V> entry = bucket.get(i);
            if (entry == null || !U.eq(entry.key, key)) continue;
            return entry;
        }
        return null;
    }
}

